{
    "scan": {
        "analyzer-version-clippy": "1.86.0",
        "analyzer-version-cppcheck": "2.17.1",
        "analyzer-version-gcc": "15.0.1",
        "analyzer-version-gcc-analyzer": "15.0.1",
        "analyzer-version-shellcheck": "0.10.0",
        "analyzer-version-unicontrol": "0.0.2",
        "enabled-plugins": "clippy, cppcheck, gcc, shellcheck, unicontrol",
        "exit-code": 0,
        "host": "ip-172-16-1-29.us-west-2.compute.internal",
        "mock-config": "fedora-rawhide-x86_64",
        "project-name": "podman-5.5.0~dev-1.20250410120910989365.main.622.d5b1eb1cad",
        "store-results-to": "/tmp/tmpm2462ibu/podman-5.5.0~dev-1.20250410120910989365.main.622.d5b1eb1cad.tar.xz",
        "time-created": "2025-04-10 12:38:55",
        "time-finished": "2025-04-10 12:51:02",
        "tool": "csmock",
        "tool-args": "'/usr/bin/csmock' '-r' 'fedora-rawhide-x86_64' '-t' 'cppcheck,shellcheck,unicontrol,clippy,gcc' '-o' '/tmp/tmpm2462ibu/podman-5.5.0~dev-1.20250410120910989365.main.622.d5b1eb1cad.tar.xz' '--gcc-analyze' '--unicontrol-notests' '--unicontrol-bidi-only' '--install' 'pam' '/tmp/tmpm2462ibu/podman-5.5.0~dev-1.20250410120910989365.main.622.d5b1eb1cad.src.rpm'",
        "tool-version": "csmock-3.8.0-1.el9"
    },
    "defects": [
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 758,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3f16682a2ecdad15619ea3f28d7e37dd2377b4e7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/etc/profile.d/podman-docker.sh",
                    "line": 1,
                    "column": 1,
                    "event": "error[SC2148]",
                    "message": "Tips depend on target shell and yours is unknown. Add a shebang or a 'shell' directive.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> # DOCKER_HOST initialization",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   if [ -z \"${DOCKER_HOST-}\" ]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "224af44d5981dae60f2ada9a2937e5c91ed2b255",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/etc/profile.d/podman-docker.sh",
                    "line": 4,
                    "column": 10,
                    "h_size": 8,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   if [ -z \"${DOCKER_HOST-}\" ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    4|->     if [ $(id -u) -eq 0 ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    5|   \texport DOCKER_HOST=unix:///run/podman/podman.sock",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    6|       else",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "815c8ed15b15b1945cd7de54f8c85f903e9d8484",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 12,
                    "column": 5,
                    "h_size": 21,
                    "event": "warning[SC2034]",
                    "message": "BATS_TEST_NAME_PREFIX appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   10|   function setup() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|       # Makes test logs easier to read",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|->     BATS_TEST_NAME_PREFIX=\"[001] \"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "92251e27de5ae47f7cdf30d1de2893d5b068037b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 32,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   30|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   31|       # Test that build date is reasonable, e.g. after 2019-01-01",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   32|->     local built=$(expr \"$output\" : \".*Built: \\+\\(.*\\)\" | head -n1)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   33|       local built_t=$(date --date=\"$built\" +%s)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   34|       assert \"$built_t\" -gt 1546300800 \"Preposterous 'Built' time in podman version\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "805a3905c8e5f7fcc4f514d70a3a1de7ab64398e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 33,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   31|       # Test that build date is reasonable, e.g. after 2019-01-01",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   32|       local built=$(expr \"$output\" : \".*Built: \\+\\(.*\\)\" | head -n1)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   33|->     local built_t=$(date --date=\"$built\" +%s)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   34|       assert \"$built_t\" -gt 1546300800 \"Preposterous 'Built' time in podman version\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   35|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8245a163495713853799cc8a15dc4f8eabd4a884",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 56,
                    "column": 46,
                    "h_size": 10,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|           'Store:{{.Store.GraphDriverName}}'",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|->     run_podman info --format \"$(IFS='/' echo ${want[@]})\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|       echo \"# $output\" >&3",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   58|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0b5ae739885b02b98527c3e40de36b6d2594718a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 117,
                    "column": 31,
                    "h_size": 7,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  115|       # Split it into its components; remove \"-remote\" from the command path;",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  116|       # and preserve any other args if present.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  117|->     local -a podman_as_array=($PODMAN)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  118|       local    podman_path=${podman_as_array[0]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  119|       local    podman_non_remote=${podman_path%%-remote}",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f368a4cca95d7afc2a443c5c41453553e7a6ef9e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 123,
                    "column": 12,
                    "h_size": 49,
                    "event": "warning[SC2124]",
                    "message": "Assigning an array to a string! Assign as array, or use * instead of @ to concatenate.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  121|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  122|       # This always worked: running \"podman --remote ...\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  123|->     PODMAN=\"${podman_non_remote} --remote ${podman_args[@]}\" run_podman version",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  124|       is \"$output\" \".*Server:\" \"podman --remote: contacts server\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  125|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "620fcc9ebd2972c8dbb1ae24b17d9e78570396db",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 127,
                    "column": 12,
                    "h_size": 67,
                    "event": "warning[SC2124]",
                    "message": "Assigning an array to a string! Assign as array, or use * instead of @ to concatenate.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  125|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  126|       # This was failing: \"podman --foo --bar --remote\".",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  127|->     PODMAN=\"${podman_non_remote} --log-level=error ${podman_args[@]} --remote\" run_podman version",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  128|       is \"$output\" \".*Server:\" \"podman [flags] --remote: contacts server\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  129|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "55c96d886bb7034a9b11dd07dc81049011e45c42",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/001-basic.bats",
                    "line": 131,
                    "column": 12,
                    "h_size": 40,
                    "event": "warning[SC2124]",
                    "message": "Assigning an array to a string! Assign as array, or use * instead of @ to concatenate.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  129|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  130|       # ...but no matter what, --remote is never allowed after subcommand",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  131|->     PODMAN=\"${podman_non_remote} ${podman_args[@]}\" run_podman 125 version --remote",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  132|       is \"$output\" \"Error: unknown flag: --remote",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  133|   See 'podman version --help'\" \"podman version --remote\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d07cdb84f662623e252c3382274d40ac5525c32a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 36,
                    "column": 5,
                    "h_size": 8,
                    "event": "warning[SC2034]",
                    "message": "expr_nvr appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   34|       run_podman info --format=json",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   35|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   36|->     expr_nvr=\"[a-z0-9-]\\\\\\+-[a-z0-9.]\\\\\\+-[a-z0-9]\\\\\\+\\.\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   37|       expr_path=\"/[a-z0-9\\\\\\/.-]\\\\\\+\\\\\\$\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   38|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "66fe7397cc414891e8f38582664cb09ee3cfbd19",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 92,
                    "column": 19,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   90|           local osrelease=/etc/os-release",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   91|           if [[ -e $osrelease ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   92|->             local osname=$(source $osrelease; echo $NAME)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   93|               if [[ $osname =~ Red.Hat ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   94|                   die \"CI_DESIRED_NETWORK must be set in gating.yaml for RHEL testing\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "66fe7397cc414891e8f38582664cb09ee3cfbd19",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 161,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  159|       test -e $osrelease || skip \"Not a RHEL system (no $osrelease)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  160|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  161|->     local osname=$(source $osrelease; echo $NAME)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  162|       if [[ $osname =~ Red.Hat || $osname =~ CentOS ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  163|           # Version can include minor; strip off first dot an all beyond it",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "765a824324875fe00802cb7ad2f4867aa9426985",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 164,
                    "column": 15,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  162|       if [[ $osname =~ Red.Hat || $osname =~ CentOS ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  163|           # Version can include minor; strip off first dot an all beyond it",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  164|->         local osver=$(source $osrelease; echo $VERSION_ID)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  165|           test ${osver%%.*} -le 8 || skip \"$osname $osver > RHEL8\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 149,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8670e89c2043832ad9b3bffefc183e8f015d3949",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 194,
                    "column": 32,
                    "h_size": 7,
                    "event": "warning[SC2027]",
                    "message": "The surrounding quotes actually unquote this. Remove or escape them.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  192|                       --storage-opt=$driver'.imagestore='$store2 \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  193|                       --format '{{index .Store.GraphOptions \"'$driver'.additionalImageStores\"}}\\n{{index .Store.GraphOptions \"'$driver'.imagestore\"}}'",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  194|->     assert \"${lines[0]}\" == \"[\"$store1\" \"$store2\"]\" \"output includes additional image stores\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  195|       assert \"${lines[1]}\" == \"$store2\" \"old imagestore output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  196|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 149,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8670e89c2043832ad9b3bffefc183e8f015d3949",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 194,
                    "column": 42,
                    "h_size": 7,
                    "event": "warning[SC2027]",
                    "message": "The surrounding quotes actually unquote this. Remove or escape them.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  192|                       --storage-opt=$driver'.imagestore='$store2 \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  193|                       --format '{{index .Store.GraphOptions \"'$driver'.additionalImageStores\"}}\\n{{index .Store.GraphOptions \"'$driver'.imagestore\"}}'",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  194|->     assert \"${lines[0]}\" == \"[\"$store1\" \"$store2\"]\" \"output includes additional image stores\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  195|       assert \"${lines[1]}\" == \"$store2\" \"old imagestore output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  196|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 480,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "85249926f21fab75b74c694d6f94262fefff659b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/005-info.bats",
                    "line": 297,
                    "column": 25,
                    "h_size": 1,
                    "event": "warning[SC1007]",
                    "message": "Remove space after = if trying to assign a value (for empty string, use var='' ... ).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  295|       safe_opts=$(podman_isolation_opts ${PODMAN_TMPDIR})",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  296|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  297|->     CI_DESIRED_DATABASE= run_podman 125 $safe_opts --db-backend=boltdb info",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  298|       assert \"$output\" =~ \"deprecated, no new BoltDB databases can be created\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  299|              \"without CI_DESIRED_DATABASE\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "22b8a9d861567a2951af01ce74744a74c7813fc6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/010-images.bats",
                    "line": 207,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  205|       local aaa_tag=d",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  206|       local zzz_name=zzzzzzzzzz.yyyyyyyyy/xxxxxxxxx",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  207|->     local zzz_tag=$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  208|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  209|       # Helper function to check one line of tabular output; all this does is",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fd4c4bc678c8fe595a919651976d0e0793ed8074",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/010-images.bats",
                    "line": 371,
                    "column": 11,
                    "h_size": 13,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  369|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  370|       # overlay or vfs",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  371|->     local storagedriver=\"$(podman_storage_driver)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  372|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  373|       local imstore=$PODMAN_TMPDIR/imagestore",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "c03afa67d9889794f903995747ae3ba7e9d1496a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/010-images.bats",
                    "line": 423,
                    "column": 39,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  421|   RUN echo $i",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  422|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  423|->         run_podman build -q -t img-$i-$(safename) $PODMAN_TMPDIR",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  424|       done",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  425|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7610fd8b63a98e1924808c47ba5509e555b2aa53",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/010-images.bats",
                    "line": 431,
                    "column": 36,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  429|       for i in $(seq --format '%02g' 1 $count); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  430|           timeout --foreground -v --kill=10 60 \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  431|->                 $PODMAN rmi img-$i-$(safename) &",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  432|       done",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  433|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "44a8e3411ab95a6c1d5bb630543d40a82f4bc20a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/010-images.bats",
                    "line": 435,
                    "column": 27,
                    "h_size": 13,
                    "event": "warning[SC2076]",
                    "message": "Remove quotes from right-hand side of =~ to match as a regex rather than literally.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  433|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  434|       tries=100",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  435|->     while [[ \"$output\" =~ \"$(safename)\" ]] && [[ $tries -gt 0 ]]; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  436|           run_podman images --format \"{{.ID}} {{.Names}}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  437|           tries=$((tries - 1))",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "06ee881a5d82f642e49f86310b1091ce9b6c12ff",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 129,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  127|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  128|       # Build two images, different arches, and add each to one manifest list",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  129|->     local img=\"i-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  130|       local manifestlocal=\"m-$(safename):1.0\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  131|       run_podman manifest create $manifestlocal",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5a9937488efc5bd436be4427c6c4855c469a5dd8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 130,
                    "column": 11,
                    "h_size": 13,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  128|       # Build two images, different arches, and add each to one manifest list",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  129|       local img=\"i-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  130|->     local manifestlocal=\"m-$(safename):1.0\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  131|       run_podman manifest create $manifestlocal",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  132|       for arch in amd arm;do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b697a0cb585ab741736f21e07b584095d50ab4d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 210,
                    "column": 16,
                    "h_size": 45,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  208|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  209|       if [[ -n \"$listFlags\" ]] ; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  210|->         assert $(jq -r '.annotations[\"global\"]' <<<\"$index\") == local \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  211|                  \"listFlags=$listFlags, .annotations[global]\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  212|       fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "12cc35a33c4ee704cf4539b055eeee9b1ce64b3a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 214,
                    "column": 16,
                    "h_size": 48,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  212|       fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  213|       if [[ -n \"$platformFlags\" ]] ; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  214|->         assert $(jq -r '.manifests[1].platform.os' <<<\"$index\") == linux \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  215|                  \"platformFlags=$platformFlags, .platform.os\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  216|           assert $(jq -r '.manifests[1].platform.architecture' <<<\"$index\") == amd64 \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8392bb29c88ccfe3af7e23467de6fb9e6458a652",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 216,
                    "column": 16,
                    "h_size": 58,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  214|           assert $(jq -r '.manifests[1].platform.os' <<<\"$index\") == linux \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  215|                  \"platformFlags=$platformFlags, .platform.os\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  216|->         assert $(jq -r '.manifests[1].platform.architecture' <<<\"$index\") == amd64 \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  217|                  \"platformFlags=$platformFlags, .platform.architecture\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  218|       fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 691,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1654f296e62f9e9f27981bc1b924d923e880419e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 229,
                    "column": 9,
                    "h_size": 12,
                    "event": "warning[SC2254]",
                    "message": "Quote expansions in case patterns to match literally rather than as a glob.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|       for digest in $firstdigest $seconddigest ; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  228|           case $digest in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  229|->         $firstdigest)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  230|               filetitle=listed.txt",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  231|               defaulttype=text/plain",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 691,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "03363a5a96ecf6df282d3d6101b91daf978f0b8b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 233,
                    "column": 9,
                    "h_size": 13,
                    "event": "warning[SC2254]",
                    "message": "Quote expansions in case patterns to match literally rather than as a glob.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  231|               defaulttype=text/plain",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  232|               ;;",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  233|->         $seconddigest)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  234|               filetitle=zeroes",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  235|               defaulttype=application/octet-stream",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d0e935aacb897bea2943a62054924bc81d2878eb",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/012-manifest.bats",
                    "line": 301,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  299|       # every flag available.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  300|       skip_if_remote \"running a local registry doesn't work with podman-remote\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  301|->     local list=\"m-$(safename):1.0\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  302|       truncate -s 20M ${PODMAN_TMPDIR}/zeroes",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  303|       echo oh yeah > ${PODMAN_TMPDIR}/listed.txt",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9778bc6863c857d8c0b768259d4238c2320ba94b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/015-help.bats",
                    "line": 133,
                    "column": 22,
                    "h_size": 4,
                    "event": "warning[SC2198]",
                    "message": "Arrays don't work as operands in [ ]. Use a loop (or concatenate with * instead of @).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  131|                   fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  132|                   # \"network rm\" too",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  133|->                 if [ \"$@\" = \"network\" -a \"$cmd\" = \"rm\" ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  134|                       continue",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  135|                   fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 477,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a6a88fb5512ff580a586a4eff4d1883f66289411",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/015-help.bats",
                    "line": 133,
                    "column": 39,
                    "h_size": 2,
                    "event": "warning[SC2166]",
                    "message": "Prefer [ p ] && [ q ] as [ p -a q ] is not well defined.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  131|                   fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  132|                   # \"network rm\" too",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  133|->                 if [ \"$@\" = \"network\" -a \"$cmd\" = \"rm\" ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  134|                       continue",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  135|                   fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "651765d92691417fdc25aa5c13982db437838fdf",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/015-help.bats",
                    "line": 154,
                    "column": 19,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  152|           # usage error.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  153|           if ! expr \"$usage\" : \".*\\.\\.\\.\"; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  154|->             local n_args=$(wc -w <<<\"$usage\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  155|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  156|               run_podman '?' \"$@\" $cmd $(seq --format='x%g' 0 $n_args)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "92ca6001716b7d415660b278cc00ce09a7edb31d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 15,
                    "column": 12,
                    "v_size": 4,
                    "event": "warning[SC2089]",
                    "message": "Quotes/backslashes will be treated literally. Use an array.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|       err_no_exec_dir=\"Error:.*\\\\\\(exec.*\\\\\\(permission denied\\\\\\|is a directory\\\\\\)\\\\\\|is not a regular file\\\\\\)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|->     tests=\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   16|   true              |   0 |",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   17|   false             |   1 |",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9930054d8313b8b484a41e94d44da40b1227c61f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 50,
                    "column": 34,
                    "h_size": 6,
                    "event": "warning[SC2090]",
                    "message": "Quotes/backslashes in this variable will not be respected.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   48|       # the rest were being silently ignored because of podman-remote",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   49|       # bug #4095, in which it slurps up stdin.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   50|->     is \"$tests_run\" \"$(grep . <<<$tests | wc -l)\" \"Ran the full set of tests\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   51|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   52|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2cde1be1a25fbf3f796d91ffa56d3e47a93e747f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 226,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "i appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  224|       run_podman run -d --name $cname --rmi $NONLOCAL_IMAGE /bin/true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  225|       # 10 chances for the image to disappear",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  226|->     for i in `seq 1 10`; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|           sleep 0.5",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  228|           run_podman '?' image exists $NONLOCAL_IMAGE",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a9942fe1c7f17cf2ec69461c3bf378b5e30c348f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 266,
                    "column": 11,
                    "h_size": 20,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  264|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  265|       # Cross-check --conmon-pidfile against 'podman inspect'",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  266|->     local conmon_pid_from_file=$(< $pidfile)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  267|       run_podman inspect --format '{{.State.ConmonPid}}' $cid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  268|       local conmon_pid_from_inspect=\"$output\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a43fdd84f8dbfc119eff6b4ad5ed84f87b7144ef",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 344,
                    "column": 69,
                    "h_size": 4,
                    "event": "warning[SC2154]",
                    "message": "dir is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  342|               for keepid in \"\" ${keep}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  343|                   opts=\"$priv $user $keepid\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  344|->                 run_podman run --rm $opts $IMAGE stat -c '%u:%g:%n' $dir /etc /usr",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  345|                   remove_same_dev_warning      # grumble",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|                   is \"${lines[0]}\" \"0:0:/etc\" \"run $opts /etc\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9082cfce487767f3d628268dc45bac6c3186980a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 506,
                    "column": 35,
                    "h_size": 15,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  504|                  --conmon-pidfile $pidfile $IMAGE echo $msg",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  505|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  506|->     journalctl --output cat  _PID=$(cat $pidfile)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  507|       is \"$output\" \"$msg\" \"check that journalctl output equals the container output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  508|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b468d70c4edc6eed147a968b67b96ab66d8ca81e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 637,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  635|   @test \"podman run : look up correct image name\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  636|       # Create a 2nd tag for the local image.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  637|->     local newtag=\"localhost/r_$(safename)/i_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  638|       run_podman tag $IMAGE $newtag",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  639|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d62f5e2ce48f295d920db7dbcc5ac53adabbada3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 689,
                    "column": 33,
                    "h_size": 103,
                    "v_size": 1,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  687|       run_podman inspect $IMAGE --format \"{{json .RepoDigests}}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  688|       # ...so, strip off the prefix and get an array of sha strings",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  689|->     declare -a expectedDigests=($(jq -r '.[]' <<<\"$output\" |\\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  690|                                         sed -e \"s;^${PODMAN_TEST_IMAGE_REGISTRY}/${PODMAN_TEST_IMAGE_USER}/${PODMAN_TEST_IMAGE_NAME}@;;\"))",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  691|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7a8314d7d5f775d7343c6fa52b365cf70b814b8e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 883,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  881|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  882|       # --layers=false needed to work around buildah#5674 parallel flake",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  883|->     local iname=nomtab-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  884|       run_podman build -t $iname --layers=false $tmpdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  885|       run_podman run --rm $iname stat -c %N /etc/mtab",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6154b640a0d917bfc2f04c234957d67682bf4d7b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/030-run.bats",
                    "line": 1590,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1588|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1589|   @test \"podman create container with conflicting name\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1590|->     local cname=c_$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1591|       local output_msg_ext=\"^Error: .*: the container name \\\"$cname\\\" is already in use by .* You have to remove that container to be able to reuse that name: that name is already in use by an external entity, or use --replace to instruct Podman to do so.\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1592|       local output_msg=\"^Error: .*: the container name \\\"$cname\\\" is already in use by .* You have to remove that container to be able to reuse that name: that name is already in use, or use --replace to instruct Podman to do so.\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "496a2fa51242ad5710c6977e0ffd9732527bace0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Basic tests for podman logs",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9b7a88586431e0210f59fabf57300e46994d0a31",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 95,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   93|       skip_if_remote \"logs does not support multiple containers when run remotely\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   94|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   95|->     local events_backend=$(_additional_events_backend $driver)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   96|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   97|       # Simple helper to make the container starts, below, easier to read",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1e9e3c8cc2e18f60ca0fac2fc618702af3a6803d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 98,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   96|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   97|       # Simple helper to make the container starts, below, easier to read",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   98|->     local cname1=\"c-ltm-1-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   99|       local cname2=\"c-ltm-2-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  100|       local -a cid",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "03ff74667216c983c5a54c17b7f7c3f22ecdbd58",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 99,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   97|       # Simple helper to make the container starts, below, easier to read",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   98|       local cname1=\"c-ltm-1-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   99|->     local cname2=\"c-ltm-2-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  100|       local -a cid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  101|       doit() {",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5c2d07064d19a6d321eb89d69f932afb6ad44f5b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 104,
                    "column": 15,
                    "h_size": 24,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  102|           run_podman ${events_backend} run --log-driver=$driver -d \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  103|               --name \"$1\" $IMAGE sh -c \"$2\";",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  104|->         cid+=($(echo \"${output:0:12}\"))",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  105|       }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  106|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9b7a88586431e0210f59fabf57300e46994d0a31",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 138,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  136|   function _log_test_restarted() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  137|       local driver=$1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  138|->     local events_backend=$(_additional_events_backend $driver)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  139|       if [[ -n \"${events_backend}\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  140|           skip_if_remote \"remote does not support --events-backend\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9b7a88586431e0210f59fabf57300e46994d0a31",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 288,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|       contentB=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|       contentC=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|->     local events_backend=$(_additional_events_backend $driver)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  289|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  290|       if [[ -n \"${events_backend}\" ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9b7a88586431e0210f59fabf57300e46994d0a31",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 321,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  319|       cname=\"c-ltfs-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  320|       content=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|->     local events_backend=$(_additional_events_backend $driver)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  322|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  323|       if [[ -n \"${events_backend}\" ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9b7a88586431e0210f59fabf57300e46994d0a31",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/035-logs.bats",
                    "line": 369,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  367|       cname=\"c-ltfu-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  368|       content=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  369|->     local events_backend=$(_additional_events_backend $driver)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  370|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  371|       if [[ -n \"${events_backend}\" ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b0cf4af1850efa4667d4e78a322bbf6ddd896ed8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 24,
                    "column": 57,
                    "h_size": 6,
                    "event": "warning[SC2154]",
                    "message": "cname is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   22|       run_podman ps",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   23|       is \"${lines[1]}\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   24|->        \"${cid:0:12} \\+$IMAGE \\+sleep [0-9]\\+ .*second.* $cname\"\\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   25|          \"output from podman ps\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 153,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a5cde0a1da528a5525ccfe81061ed34e8b28352d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 47,
                    "column": 37,
                    "h_size": 19,
                    "event": "warning[SC2053]",
                    "message": "Quote the right-hand side of == in [[ ]] to prevent glob matching.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   45|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   46|       cid[stopped]=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   47|->     while [[ ${cid[stopped]:0:1} == ${cid[running]:0:1} ]]; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   48|           run_podman rm -f stopped",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   49|           run_podman run -d --name stopped $IMAGE true",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 153,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f4c35d3ce9042211ea199dd308616a1a79b2c4d7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 55,
                    "column": 36,
                    "h_size": 19,
                    "event": "warning[SC2053]",
                    "message": "Quote the right-hand side of == in [[ ]] to prevent glob matching.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   53|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|       cid[failed]=${cid[stopped]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|->     while [[ ${cid[failed]:0:1} == ${cid[running]:0:1} ]] || [[ ${cid[failed]:0:1} == ${cid[stopped]:0:1} ]]; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|           run_podman rm -f failed",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|           run_podman run -d --name failed $IMAGE false",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 153,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f4c35d3ce9042211ea199dd308616a1a79b2c4d7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 55,
                    "column": 87,
                    "h_size": 19,
                    "event": "warning[SC2053]",
                    "message": "Quote the right-hand side of == in [[ ]] to prevent glob matching.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   53|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|       cid[failed]=${cid[stopped]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|->     while [[ ${cid[failed]:0:1} == ${cid[running]:0:1} ]] || [[ ${cid[failed]:0:1} == ${cid[stopped]:0:1} ]]; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|           run_podman rm -f failed",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|           run_podman run -d --name failed $IMAGE false",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "28c007206cabf58f44c23d14725b95d0ee076cbf",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 205,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2178]",
                    "message": "Variable was used as an array but is now assigned a string.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  203|       is \"${#lines[@]}\" \"2\" \"podman ps -a --external sees buildah containers\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  204|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  205|->     cid=\"${lines[1]:0:12}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  206|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  207|       # We can't rm it without -f, but podman should issue a helpful message",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b121f8edff848f55bb8c30ec76d391c856e5a3f4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 208,
                    "column": 22,
                    "h_size": 4,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  206|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  207|       # We can't rm it without -f, but podman should issue a helpful message",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  208|->     run_podman 2 rm \"$cid\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  209|       is \"$output\" \"Error: container .* is mounted and cannot be removed without using force: container state improper\" \"podman rm <buildah container> without -f\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  210|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0392f926405009562046cefbacb1afdb56212fea",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 212,
                    "column": 28,
                    "h_size": 4,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  210|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  211|       # With -f, we can remove it.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  212|->     run_podman rm -t 0 -f \"$cid\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  213|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  214|       run_podman ps --external",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1a3ec59f1855391e7d302b13a1d010b6c4170313",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 222,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2178]",
                    "message": "Variable was used as an array but is now assigned a string.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  220|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  221|       run_podman run -d --label mylabel=$rand_value $IMAGE sleep inf",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  222|->     cid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  223|       is \"$cid\" \"[0-9a-f]\\{64\\}$\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  224|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e3358479c3f2bc5a61518bb5c2d9fc87f2589351",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 223,
                    "column": 9,
                    "h_size": 4,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  221|       run_podman run -d --label mylabel=$rand_value $IMAGE sleep inf",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  222|       cid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  223|->     is \"$cid\" \"[0-9a-f]\\{64\\}$\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  224|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  225|       run_podman ps --format '{{ .Label \"mylabel\" }}'",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2b82748e0cf5cc7f5a60ed79454d0e1905e7e79a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 228,
                    "column": 27,
                    "h_size": 4,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  226|       is \"$output\" \"$rand_value\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  228|->     run_podman rm -t 0 -f $cid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  229|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  230|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7aba4dc987e5149d3d60362c20f2f42b85af4ff1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 240,
                    "column": 20,
                    "h_size": 14,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  238|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  239|       run_podman pod rm -t 0 -f test",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  240|->     run_podman rmi $(pause_image)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  241|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  242|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1a3ec59f1855391e7d302b13a1d010b6c4170313",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 247,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2178]",
                    "message": "Variable was used as an array but is now assigned a string.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  245|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  246|       run_podman run -d --pod new:${rand_value} --label mylabel=$rand_value $IMAGE sleep inf",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  247|->     cid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  248|       is \"$cid\" \"[0-9a-f]\\{64\\}$\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  249|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e3358479c3f2bc5a61518bb5c2d9fc87f2589351",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 248,
                    "column": 9,
                    "h_size": 4,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  246|       run_podman run -d --pod new:${rand_value} --label mylabel=$rand_value $IMAGE sleep inf",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  247|       cid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  248|->     is \"$cid\" \"[0-9a-f]\\{64\\}$\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  249|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  250|       run_podman ps --format '{{ .PodName }}'",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2b82748e0cf5cc7f5a60ed79454d0e1905e7e79a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 253,
                    "column": 27,
                    "h_size": 4,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  251|       is \"$output\" \".*$rand_value\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  252|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  253|->     run_podman rm -t 0 -f $cid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  254|       run_podman pod rm -t 0 -f $rand_value",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  255|       run_podman rmi $(pause_image)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7aba4dc987e5149d3d60362c20f2f42b85af4ff1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/040-ps.bats",
                    "line": 255,
                    "column": 20,
                    "h_size": 14,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  253|       run_podman rm -t 0 -f $cid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  254|       run_podman pod rm -t 0 -f $rand_value",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  255|->     run_podman rmi $(pause_image)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  256|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  257|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d1547497bd774461d82ace36724f778a688543e9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/045-start.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   load helpers",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "017b4b94568f004922c582ae5ac59686f865ce39",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/045-start.bats",
                    "line": 51,
                    "column": 5,
                    "h_size": 5,
                    "event": "warning[SC2034]",
                    "message": "c2_id appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   49|       c1_id=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   50|       run_podman create --name=$c2 --restart=on-failure $IMAGE /bin/true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   51|->     c2_id=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   52|       run_podman create --name=$c3 --restart=always $IMAGE /bin/true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   53|       c3_id=\"$output\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "730e8c8bc7c796fb928d76587bf04d7ca417c775",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/050-stop.bats",
                    "line": 262,
                    "column": 11,
                    "h_size": 2,
                    "event": "warning[SC2010]",
                    "message": "Don't use ls | grep. Use a glob or a for loop with a condition to allow non-alphanumeric filenames.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  260|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  261|       # Check the OCI runtime directory has removed.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  262|->     is \"$(ls $OCIDir | grep $cid)\" \"\" \"The OCI runtime directory should have been removed\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  263|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  264|   # vim: filetype=sh",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6119a47092327a63e880fb043450e5c0102d2499",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman rm",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "af40f887ff302f084142f3b66c7b322d24243e14",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 78,
                    "column": 11,
                    "h_size": 2,
                    "event": "warning[SC2010]",
                    "message": "Don't use ls | grep. Use a glob or a for loop with a condition to allow non-alphanumeric filenames.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   76|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   77|       # Check the OCI runtime directory has removed.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   78|->     is \"$(ls $OCIDir | grep $cid)\" \"\" \"The OCI runtime directory should have been removed\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   79|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   80|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "43e559ecae854d1d1f71b096c7ea2e3cd7ca4260",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 113,
                    "column": 37,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  111|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  112|   @test \"podman container rm --force bogus\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  113|->     run_podman 1 container rm bogus-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  114|       is \"$output\" \"Error: no container with ID or name \\\"bogus-$(safename)\\\" found: no such container\" \"Should print error\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  115|       run_podman container rm --force bogus-$(safename)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "90e73a1ead45f6beb6518955f8bfc7380dc40704",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 115,
                    "column": 43,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  113|       run_podman 1 container rm bogus-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  114|       is \"$output\" \"Error: no container with ID or name \\\"bogus-$(safename)\\\" found: no such container\" \"Should print error\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  115|->     run_podman container rm --force bogus-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  116|       is \"$output\" \"\" \"Should print no output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  117|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8cf788baf3f941b6757067841acd0ecbd25cd334",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 118,
                    "column": 38,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  116|       is \"$output\" \"\" \"Should print no output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  117|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  118|->     run_podman create --name testctr-$(safename) $IMAGE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  119|       run_podman container rm --force bogus-$(safename) testctr-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  120|       assert \"$output\" = \"testctr-$(safename)\" \"should delete test\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cb8bda58088cad7b18bbd7b6d788ea6d777d5282",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 119,
                    "column": 43,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  117|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  118|       run_podman create --name testctr-$(safename) $IMAGE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  119|->     run_podman container rm --force bogus-$(safename) testctr-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  120|       assert \"$output\" = \"testctr-$(safename)\" \"should delete test\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  121|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cb8bda58088cad7b18bbd7b6d788ea6d777d5282",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 119,
                    "column": 63,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  117|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  118|       run_podman create --name testctr-$(safename) $IMAGE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  119|->     run_podman container rm --force bogus-$(safename) testctr-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  120|       assert \"$output\" = \"testctr-$(safename)\" \"should delete test\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  121|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "725a288a0ba96f49188fa23b955a77b3855b1a5e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 143,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  141|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  142|   @test \"podman container rm doesn't affect stopping containers\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  143|->     local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  144|       __run_healthcheck_container $cname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  145|       local cid=$output",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "725a288a0ba96f49188fa23b955a77b3855b1a5e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 181,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  179|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  180|   @test \"podman container rm --force doesn't leave running processes\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  181|->     local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  182|       __run_healthcheck_container $cname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  183|       local cid=$output",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e07b91d19b9f79735a58b39f3b59e4a5cf21ff5d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/055-rm.bats",
                    "line": 189,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "i appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  187|       local pid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  188|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  189|->     for i in {1..10}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  190|           run_podman inspect $cname --format '{{.State.Status}}'",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  191|           if [ \"$output\" = \"stopping\" ]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fcb2fd00df59716b82ac4bb617b26f8f504e0a06",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 24,
                    "column": 8,
                    "h_size": 26,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   22|       test -d $mount_path",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   23|       test -e \"$mount_path/$f_path\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   24|->     is $(< \"$mount_path/$f_path\") \"$f_content\" \"contents of file, as read via fs\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   25|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|       # Make sure that 'podman mount' (no args) returns the expected path and CID",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "523c4a6b1a3affe081a3a2a57ec0c33411760d6b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 73,
                    "column": 8,
                    "h_size": 33,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   71|       testimage_file=\"/home/podman/testimage-id\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   72|       test -e \"$mount_path$testimage_file\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   73|->     is $(< \"$mount_path$testimage_file\") \"$PODMAN_TEST_IMAGE_TAG\"  \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   74|          \"Contents of $testimage_file in image\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   75|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "000f3ae274abedd5afd246f827ca72b54198cd7b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 125,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  123|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  124|       # For parallel safety: create a temporary image to use for mounts",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  125|->     local tmpctr=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  126|       local iname=\"i-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  127|       run_podman run --name $tmpctr $IMAGE true",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "759ef9c654ef5a932c9f47f04ebaf7cced7a35c1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 126,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  124|       # For parallel safety: create a temporary image to use for mounts",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  125|       local tmpctr=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  126|->     local iname=\"i-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  127|       run_podman run --name $tmpctr $IMAGE true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  128|       run_podman commit -q $tmpctr $iname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3f8c1762100c2a810dbc75ca0448e55eedc6ba2e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 288,
                    "column": 44,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|       # Create a container that podman does not know about",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|->     external_cname=$(buildah from --name b-$(safename) $IMAGE)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  289|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  290|       run_podman mount $external_cname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2861e5e972ecc3d201dd4e0db5cb8304177bd499",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 301,
                    "column": 8,
                    "h_size": 43,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  299|       # Test image will always have this file, and will always have the tag",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  300|       test -d $mount_path",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  301|->     is $(< \"$mount_path/home/podman/testimage-id\") \"$PODMAN_TEST_IMAGE_TAG\"  \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  302|          \"Contents of well-known file in image\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  303|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fd1860c67ac915ba6f0e72a562aa4d1cc5faa495",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 400,
                    "column": 10,
                    "h_size": 17,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  398|       # absolute (abs) symlinks.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  399|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  400|->     if [ $(podman_runtime) != \"crun\" ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  401|           # Requires crun >= 1.11.0",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  402|           skip \"only crun supports the no-dereference (copy-symlink) mount option\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 149,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "835194852bb6c37d8654ec6e699b751a934e7a79",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 545,
                    "column": 86,
                    "h_size": 5,
                    "event": "warning[SC2140]",
                    "message": "Word is of the form \"A\"B\"C\" (B indicated). Did you mean \"ABC\" or \"A\\\"B\\\"C\"?",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  543|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  544|                       run_podman $exit_code run \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  545|->                                --mount type=$mount_type,src=\"$sourcedir$mount_source\",dst=\"$mount_dest$mount_opts\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  546|                                  --rm --privileged $img sh -c \"stat -c '%N' $containerpath; cat $containerpath\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  547|                       assert \"${lines[0]}\" = \"$expect_stat\" \"$description -- stat $containerpath\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "16c8aaa42c563e50022695f3f7ecc45572c90119",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 559,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  557|       local workdir=$PODMAN_TMPDIR/test-restart",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  558|       mkdir $workdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  559|->     local datafile=\"data-$(random_string 5)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  560|       local datafile_contents=\"What we expect to see, $(random_string 20)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  561|       echo \"$datafile_contents\" > $workdir/$datafile",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "24b202af6a6854e0f89d0a656d765d18c9ec6ee7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/060-mount.bats",
                    "line": 560,
                    "column": 11,
                    "h_size": 17,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  558|       mkdir $workdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  559|       local datafile=\"data-$(random_string 5)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  560|->     local datafile_contents=\"What we expect to see, $(random_string 20)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  561|       echo \"$datafile_contents\" > $workdir/$datafile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  562|       ln -s $datafile $workdir/link",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d3c946c45ed1eef94d0b9011b8be3ce679834d89",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for 'podman cp'",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 17,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|       mkdir -p $srcdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   16|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   17|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   18|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   19|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 18,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   16|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   17|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   18|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   19|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   20|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "61d24fc40d5fc06114b58f0881eadfd2232b1b66",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 19,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   17|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   18|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   19|->         random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   20|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   21|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5537b0bc2650a9e14475dff3bfee767a14cdfab9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 28,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|       echo \"${randomcontent[2]}\" > $srcdir/subdir/dotfile.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   27|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   28|->     local destrunning=\"c-destrun-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   29|       run_podman run -d --name $destrunning --workdir=/srv $IMAGE sh -c \"mkdir /srv/subdir; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   30|       wait_for_ready $destrunning",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d7e7c3aaa25c0973950ff753d4cf02df94e85575",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 83,
                    "column": 15,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   81|       # CREATED container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   82|       while read id dest dest_fullname description; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   83|->         local destcreated=\"c-destcreated-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   84|           run_podman create --name $destcreated --workdir=/srv $cpimage sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   85|           run_podman cp $srcdir/hostfile$id $destcreated:$dest",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5537b0bc2650a9e14475dff3bfee767a14cdfab9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 103,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  101|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  102|       # RUNNING container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  103|->     local destrunning=\"c-destrun-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  104|       run_podman run -d --mount type=tmpfs,dst=/tmp --name $destrunning $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  105|       run_podman cp $srcdir/file $destrunning:/tmp",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ddc93099e2cc494a9b7bf02752432b9b884f3455",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 111,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  109|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  110|       # CREATED container (with copy up)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  111|->     local destcreated=cdestcreated$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  112|       run_podman create --mount type=tmpfs,dst=/tmp --name $destcreated $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  113|       run_podman cp $srcdir/file $destcreated:/tmp",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5537b0bc2650a9e14475dff3bfee767a14cdfab9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 130,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  128|       keepid=\"--userns=keep-id\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  129|       is_rootless || keepid=\"\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  130|->     local destrunning=\"c-destrun-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  131|       run_podman run --user=$userid ${keepid} -d --name $destrunning $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  132|       run_podman cp $srcdir/hostfile $destrunning:/tmp/hostfile",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5537b0bc2650a9e14475dff3bfee767a14cdfab9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 151,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  149|       keepid=\"--userns=keep-id\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  150|       is_rootless || keepid=\"\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  151|->     local destrunning=\"c-destrun-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  152|       run_podman run --user=$userid ${keepid} -d --name $destrunning $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  153|       run_podman cp -a=false - $destrunning:/tmp/ < \"${tmpdir}/a.tar\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "49a164b40ca1b50a6810c2507ba164aec9e6891c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 168,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|       touch $srcdir/hostfile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|->     local cpcontainer=\"cpctr-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  169|       run_podman run --pid=host -d --name $cpcontainer $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  170|       run_podman cp $srcdir/hostfile $cpcontainer:/tmp/hostfile",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 181,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  179|       # Create 3 files with random content in the container.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  180|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  181|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  182|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  183|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 182,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  180|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  181|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  182|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  183|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  184|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "61d24fc40d5fc06114b58f0881eadfd2232b1b66",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 183,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  181|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  182|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  183|->         random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  184|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  185|       local srcrunning=\"c-srcrun-$(safename)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "043f75b802472bbb7a97fa7bc84ce713d068239e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 185,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  183|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  184|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  185|->     local srcrunning=\"c-srcrun-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  186|       run_podman run -d --name $srcrunning --workdir=/srv $IMAGE sh -c \"mkdir /srv/subdir;",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  187|            echo ${randomcontent[0]} > /tmp/containerfile;",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b08e42d1d4b807797384919c5689a9d605598b5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 225,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  223|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  224|       # Created container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  225|->     local srccreated=\"c-src-crt-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  226|       run_podman create --name $srccreated --workdir=/srv $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|       while read id src dest dest_fullname description; do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 244,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  242|       # Create 3 files with random content in the container.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  243|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  244|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  245|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  246|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 245,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  243|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  244|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  245|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  246|           random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  247|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "61d24fc40d5fc06114b58f0881eadfd2232b1b66",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 246,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  244|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  245|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  246|->         random-2-$(random_string 20)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  247|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  248|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0efb5ce67fd4b10f504d5b0be8381e78a5ba913a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 249,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  247|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  248|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  249|->     local srcrunning=\"c-src-run-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  250|       run_podman run -d --name $srcrunning --workdir=/srv $IMAGE sh -c \"mkdir /srv/subdir;",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  251|            echo ${randomcontent[0]} > /tmp/containerfile;",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 287,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  285|           run_podman run -d $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|           run_podman cp $srcrunning:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  289|           run_podman exec $destcontainer cat \"$dest_fullname\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 295,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  293|           run_podman create $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  294|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  295|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  296|           run_podman cp $srcrunning:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  297|           run_podman start $destcontainer",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "951ef9efb1b1ae75864669b12a3867371697548d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 301,
                    "column": 39,
                    "h_size": 20,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  299|           is \"$output\" \"${randomcontent[$id]}\" \"$description (cp ctr:$src to $dest - CREATED)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  300|       done < <(parse_table \"$tests\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  301|->     run_podman rm -t 0 -f $srcrunning ${destcontainers[@]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  302|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  303|       # From CREATED container",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b08e42d1d4b807797384919c5689a9d605598b5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 305,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  303|       # From CREATED container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  304|       destcontainers=()",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  305|->     local srccreated=\"c-src-crt-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  306|       run_podman create --name $srccreated --workdir=/srv $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  307|       while read id src dest dest_fullname description; do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 316,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  314|           run_podman run -d $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  315|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  316|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  317|           run_podman cp $srccreated:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  318|           run_podman exec $destcontainer cat \"$dest_fullname\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 323,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|           run_podman create $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  322|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  323|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  324|           run_podman cp $srccreated:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  325|           run_podman start $destcontainer",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "742b90e5f855bf4d3a4d695ee37f3577d3734470",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 329,
                    "column": 39,
                    "h_size": 20,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  327|           is \"$output\" \"${randomcontent[$id]}\" \"$description (cp ctr:$src to $dest)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  328|       done < <(parse_table \"$tests\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  329|->     run_podman rm -t 0 -f $srccreated ${destcontainers[@]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  330|       run_podman rmi -f $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  331|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 337,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  335|       mkdir -p $srcdir/dir/sub",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  336|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  337|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  338|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  339|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 338,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  336|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  337|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  338|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  339|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  340|       echo \"${randomcontent[0]}\" > $srcdir/dir/sub/hostfile0",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5537b0bc2650a9e14475dff3bfee767a14cdfab9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 348,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       cp -r $srcdir/dir/* $srcdir/dir.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|->     local destrunning=\"c-destrun-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|       run_podman run -d --name $destrunning --workdir=/srv $IMAGE sh -c \"mkdir /srv/subdir; echo READY;sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  350|       wait_for_ready $destrunning",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8f6cf205f9424d214cd40d1ff2e870e609b8d016",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 380,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  378|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  379|       # CREATED container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  380|->     local destcreated=\"c-dest-created-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  381|       run_podman create --name $destcreated --workdir=/srv $cpimage sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  382|       while read src dest dest_fullname description; do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3d0ab1ca6c4baf7934e3f0903f1f07268ca47f59",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 396,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  394|       run_podman rm -t 0 -f $destcreated",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  395|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  396|->     local destnotdir=\"c-destnotdir-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  397|       run_podman create --name $destnotdir --workdir=/srv $cpimage sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  398|       run_podman 125 cp $srcdir $destnotdir:/etc/os-release",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 411,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  409|       # Create 2 files with random content in the container.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  410|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  411|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  412|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  413|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 412,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  410|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  411|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  412|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  413|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  414|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0efb5ce67fd4b10f504d5b0be8381e78a5ba913a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 415,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  413|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  414|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  415|->     local srcrunning=\"c-src-run-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  416|       run_podman run -d --name $srcrunning --workdir=/srv $IMAGE sh -c \"mkdir /srv/subdir;",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  417|            echo ${randomcontent[0]} > /srv/subdir/containerfile0; \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b08e42d1d4b807797384919c5689a9d605598b5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 457,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  455|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|       # CREATED container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  457|->     local srccreated=\"c-src-crt-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|       run_podman create --name $srccreated --workdir=/srv $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|       while read src dest dest_fullname description; do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 483,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  481|       # Create 2 files with random content in the container.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  482|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  483|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  484|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  485|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 484,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  482|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  483|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  484|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  485|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  486|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0efb5ce67fd4b10f504d5b0be8381e78a5ba913a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 487,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  485|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  486|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  487|->     local srcrunning=\"c-src-run-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  488|       run_podman run -d --name $srcrunning --workdir=/srv $IMAGE sh -c \"mkdir /srv/subdir;",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  489|            echo ${randomcontent[0]} > /srv/subdir/containerfile0; \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 523,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  521|           run_podman run -d $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  522|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  523|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  524|           run_podman cp $srcrunning:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  525|           run_podman exec $destcontainer cat \"$dest_fullname/containerfile0\" \"$dest_fullname/containerfile1\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 531,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  529|           run_podman create $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  530|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  531|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  532|           run_podman cp $srcrunning:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  533|           run_podman start $destcontainer",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "951ef9efb1b1ae75864669b12a3867371697548d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 537,
                    "column": 39,
                    "h_size": 20,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  535|           is \"$(echo $output)\" \"${randomcontent[*]}\" \"$description - from RUNNING to CREATED/STARTED\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  536|       done < <(parse_table \"$tests\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|->     run_podman rm -t 0 -f $srcrunning ${destcontainers[@]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  538|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|       # From CREATED container",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b08e42d1d4b807797384919c5689a9d605598b5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 541,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|       # From CREATED container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  540|       destcontainers=()",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  541|->     local srccreated=\"c-src-crt-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  542|       run_podman create --name $srccreated --workdir=/srv $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  543|       while read src dest dest_fullname description; do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 551,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  549|           run_podman run -d $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  550|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  551|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  552|           run_podman cp $srccreated:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  553|           run_podman exec $destcontainer cat \"$dest_fullname/containerfile0\" \"$dest_fullname/containerfile1\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "722ae20a3cebc2eeed2295eafd0dbc6d2038ac9a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 559,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  557|           run_podman create $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  558|           destcontainer=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  559|->         destcontainers+=($destcontainer)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  560|           run_podman start $destcontainer",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  561|           run_podman cp $srccreated:$src $destcontainer:\"$dest\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "742b90e5f855bf4d3a4d695ee37f3577d3734470",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 566,
                    "column": 39,
                    "h_size": 20,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  564|       done < <(parse_table \"$tests\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  565|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  566|->     run_podman rm -t 0 -f $srccreated ${destcontainers[@]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  567|       run_podman rmi -f $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  568|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228821abb9946cf30b5ed2f7be6e93eed8739765",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 576,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  574|       # Create 3 files with random content in the container.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  575|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  576|->         random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  577|           random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  578|       )",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a96926b3299a2886a926a55c8cd118d912c8d368",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 577,
                    "column": 18,
                    "h_size": 19,
                    "event": "warning[SC2207]",
                    "message": "Prefer mapfile or read -a to split command output (or quote to avoid splitting).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  575|       local -a randomcontent=(",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  576|           random-0-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  577|->         random-1-$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  578|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  579|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0efb5ce67fd4b10f504d5b0be8381e78a5ba913a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 580,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  578|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  579|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  580|->     local srcrunning=\"c-src-run-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  581|       run_podman run -d --name $srcrunning $IMAGE sh -c \"echo ${randomcontent[0]} > /tmp/containerfile0; \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  582|            echo ${randomcontent[1]} > /tmp/containerfile1; \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b08e42d1d4b807797384919c5689a9d605598b5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 604,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  602|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  603|       # CREATED container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  604|->     local srccreated=\"c-src-crt-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  605|       run_podman create --name $srccreated $cpimage",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  606|       run_podman cp $srccreated:/tmp/sub/weirdlink $destdir/dest",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "13163b3b4a76e4f54d3d852b2180b49239fb1e7f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 635,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  633|       # This test is extra tricky, as volume2 is mounted into a sub-directory of",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  634|       # volume1.  Podman must copy the file into volume2 and not volume1.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  635|->     local cpcontainer=\"c-cp_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  636|       run_podman create --name $cpcontainer -v $volume1:/tmp/volume -v $volume2:/tmp/volume/sub-volume $IMAGE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  637|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 660,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  658|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  659|       # Make it a bit more complex and put the mount on a volume.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  660|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  661|       run_podman create --name $cpcontainer -v $volume:/tmp/volume -v $mountdir:/tmp/volume/mount $IMAGE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  662|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 685,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  683|       rand_content2=$(random_string 50)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  684|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  685|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  686|       run_podman run --name $cpcontainer $IMAGE sh -c \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  687|                  \"echo $rand_content1 >/tmp/$rand_filename1;",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 705,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  703|       echo \"this file is on the host\" >$srcdir/hostfile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  704|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  705|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  706|       run_podman run --name $cpcontainer $IMAGE \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  707|                  sh -c \"ln -s $srcdir/hostfile /tmp/badlink\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 733,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  731|       echo \"This file is on the host\" > $srcdir/hostfile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  732|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  733|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  734|       run_podman run --name $cpcontainer $IMAGE \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  735|                  sh -c \"ln -s $srcdir/hostfile file1;ln -s file\\* copyme\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 754,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  752|       echo \"This file lives on the host\" > $srcdir/hostfile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  753|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  754|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  755|       run_podman run --name $cpcontainer $IMAGE \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  756|                  sh -c \"ln -s $srcdir/hostfile /tmp/\\*\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 788,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  786|       # Create tmp subdirectories in container, most with an invalid 'x' symlink",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  787|       # Keep container running so we can exec into it.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  788|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  789|       run_podman run -d --name $cpcontainer $IMAGE \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  790|                  sh -c \"mkdir /tmp/d1;ln -s /tmp/nonesuch1 /tmp/d1/x;",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 843,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  841|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  842|       # Create that directory in the container, and keep container running",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  843|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  844|       run_podman run -d --name $cpcontainer $IMAGE sh -c \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  845|                  \"mkdir -p $graphroot; echo READY; top\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 876,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  874|       tar -zvcf $tar_file $srcdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  875|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  876|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  877|       run_podman run -d --name $cpcontainer $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  878|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "caa9b6a8477cccabf2e8d4e1bee25b413f73d767",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 917,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  915|       rand_content=$(random_string 50)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  916|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  917|->     local cpcontainer=\"c-cp-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  918|       run_podman run -d --name $cpcontainer $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  919|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "24dfc00a4b98372b9f7e3c7c82b0e8bf709a358b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 959,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  957|       rand_content_dir=$(random_string 50)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  958|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  959|->     local ctrfile=\"c-f-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  960|       local ctrdir=\"c-d-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  961|       run_podman run -d --name $ctrfile $IMAGE sh -c \"echo '$rand_content_file' > /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8359ff71ec923ae2de740fc81b7bf7ad89c435a7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 960,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  958|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  959|       local ctrfile=\"c-f-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  960|->     local ctrdir=\"c-d-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  961|       run_podman run -d --name $ctrfile $IMAGE sh -c \"echo '$rand_content_file' > /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  962|       run_podman run -d --name $ctrdir  $IMAGE sh -c \"mkdir /tmp/foo; echo '$rand_content_dir' > /tmp/foo/file.txt; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "24dfc00a4b98372b9f7e3c7c82b0e8bf709a358b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 997,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  995|       rand_content_dir=$(random_string 50)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  996|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  997|->     local ctrfile=\"c-f-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  998|       local ctrdir=\"c-d-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  999|       run_podman run -d --name $ctrfile $IMAGE sh -c \"echo '$rand_content_file' > /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8359ff71ec923ae2de740fc81b7bf7ad89c435a7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 998,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  996|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  997|       local ctrfile=\"c-f-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  998|->     local ctrdir=\"c-d-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  999|       run_podman run -d --name $ctrfile $IMAGE sh -c \"echo '$rand_content_file' > /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1000|       run_podman run -d --name $ctrdir  $IMAGE sh -c \"mkdir /tmp/foo; echo '$rand_content_dir' > /tmp/foo/file.txt; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "24dfc00a4b98372b9f7e3c7c82b0e8bf709a358b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1033,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1031|       rand_content_dir=$(random_string 50)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1032|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1033|->     local ctrfile=\"c-f-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1034|       local ctrdir=\"c-d-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1035|       run_podman run -d --name $ctrdir  $IMAGE sh -c \"mkdir /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8359ff71ec923ae2de740fc81b7bf7ad89c435a7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1034,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1032|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1033|       local ctrfile=\"c-f-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1034|->     local ctrdir=\"c-d-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1035|       run_podman run -d --name $ctrdir  $IMAGE sh -c \"mkdir /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1036|       run_podman run -d --name $ctrfile $IMAGE sh -c \"touch /tmp/foo; echo READY; sleep infinity\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0d4313d780fa947749ad4c5f65273f7a2f391081",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1072,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1070|       touch $srcdir/test1./file1 $srcdir/test2/file2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1071|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1072|->     local cname=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1073|       run_podman run -d --name=$cname --rm $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1074|       run_podman cp $srcdir/test1. $cname:/tmp/foo",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0d4313d780fa947749ad4c5f65273f7a2f391081",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1085,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1083|       mkdir -p $dstdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1084|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1085|->     local cname=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1086|       run_podman run -d --name=$cname --rm $IMAGE sh -c \"mkdir -p /foo/test1. /foo/test2; touch /foo/test1./file1 /foo/test2/file2; echo READY;sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1087|       wait_for_ready $cname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1a62562eb0206bdf9eba723ccbae2f0ff33b6427",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1097,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1095|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1096|   @test \"podman cp - dot notation - container to container\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1097|->     local ctrsrc=\"c-src-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1098|       run_podman run -d --name=$ctrsrc --rm $IMAGE sh -c \"mkdir -p /foo/test1. /foo/test2; touch /foo/test1./file1 /foo/test2/file2; echo READY;sleep infinity\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1099|       wait_for_ready $ctrsrc",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6776deb16f7ed32b06ea6233e977d9fc142950b6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/065-cp.bats",
                    "line": 1101,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1099|       wait_for_ready $ctrsrc",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1100|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1101|->     local ctrdest=\"c-test-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1102|       run_podman run -d --name=$ctrdest --rm $IMAGE sleep infinity",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1103|       run_podman cp $ctrsrc:/foo/test1. $ctrdest:/foo",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "759fe6afb4ee425aa5a803065cb5485f85ddcc41",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 255,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  253|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  254|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  255|->     local imgbase=\"b-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  256|       local count=10",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  257|       for i in $(seq --format '%02g' 1 $count); do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cfb3410dc88ab84aaedf13650d3c0dcb56608138",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 335,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  333|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  334|       # For --dns-search: a domain that is unlikely to exist",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  335|->     local nosuchdomain=nx$(random_string 10).net",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  336|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  337|       # Command to run on container startup with no args",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "17ca4940268839eefe829755bafb23f3bc2f8578",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 358,
                    "column": 11,
                    "h_size": 18,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  356|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  357|       # Build args: one explicit (foo=bar), one implicit (foo)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  358|->     local arg_implicit_value=implicit_$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  359|       local arg_explicit_value=explicit_$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  360|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "543ddb09fdbe563d0d7fe24d811dd5a31c382204",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 359,
                    "column": 11,
                    "h_size": 18,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  357|       # Build args: one explicit (foo=bar), one implicit (foo)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  358|       local arg_implicit_value=implicit_$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  359|->     local arg_explicit_value=explicit_$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  360|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  361|       # NOTE: it's important to not create the workdir.",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d826db63ba5e4e0051a33c4d7488257a686731a5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 567,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  565|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  566|   @test \"podman build - COPY with ignore\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  567|->     local tmpdir=$PODMAN_TMPDIR/build-test-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  568|       mkdir -p $tmpdir/subdir{1,2}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  569|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fd63d3ffb39d42cd430792249635cac29ce2b7e9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 595,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  593|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  594|       # Directory that doesn't exist in the image; COPY should create it",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  595|->     local newdir=/newdir-$(random_string 12)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  596|       cat >$tmpdir/Containerfile <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  597|   FROM $IMAGE",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b4ecf97c87d529df2c8d322e75873d21524c1d21",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 636,
                    "column": 18,
                    "h_size": 11,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  634|           # takes a second or so, and we are mindful of each second.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  635|           run_podman run --rm $imgname find $newdir -type f",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  636|->         for f in ${files[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  637|               if [[ $f =~ ^- ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  638|                   f=${f##-}",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d826db63ba5e4e0051a33c4d7488257a686731a5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 656,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  654|   # the Containerfile/Dockerfile in the context dir are used",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  655|   @test \"podman build with ignore '*'\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  656|->     local tmpdir=$PODMAN_TMPDIR/build-test-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  657|       mkdir -p $tmpdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  658|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d826db63ba5e4e0051a33c4d7488257a686731a5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 696,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  694|   # Regression test for #20259",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  695|   @test \"podman build with ignore '*' and containerfile outside of build context\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  696|->     local tmpdir=$PODMAN_TMPDIR/build-test-$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  697|       mkdir -p $tmpdir",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  698|       mkdir -p $tmpdir/context",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1b251160b76f465ef1ad874ee410c91fa180d336",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 908,
                    "column": 11,
                    "h_size": 13,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  906|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  907|       # First, confirm that --pull-never is a NOP if image exists locally",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  908|->     local random_string=$(random_string 15)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  909|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  910|       cat >$tmpdir/Containerfile <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f95166d4eb407ce21845b4a874b646d5ef6f3d1f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 1009,
                    "column": 18,
                    "h_size": 24,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1007|       local -a linkfiles=(hardlink1 subdir/hardlink2 subdir/subsubdir/hardlink3)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1008|       for l in \"${linkfiles[@]}\"; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1009|->         mkdir -p $(dirname $build_dir/$l)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1010|           ln $dockerfile $build_dir/$l",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1011|       done",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ed7318919b5683b7c731544660bec111de702b02",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/070-build.bats",
                    "line": 1204,
                    "column": 29,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1202|       # test failures. Try a last-ditch force-rm in cleanup, ignoring errors.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1203|       run_podman '?' rm -t 0 -a -f",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1204|->     run_podman '?' rmi -f b-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1205|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1206|       # Many of the tests above leave interim layers behind. Clean them up.",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d6ce8103f4394d3292fee6cfeabdd1d4e871d375",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/075-exec.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for podman exec",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3200a5ea8bc757963b4de8a1b11ccb3a70ade8de",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/075-exec.bats",
                    "line": 220,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "i appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  218|       cid=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  219|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  220|->     for i in {1..3}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  221|           run_podman 127 exec $cid blahblah",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  222|           run_podman 125 exec -d $cid blahblah",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cd13ee6ec98b141471e48991c12792e1a4826978",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/080-pause.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman pause/unpause functionality",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "31e7334e815df0db95dbde35d6201b2a9c5a5e55",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/080-pause.bats",
                    "line": 97,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   95|       fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   96|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   97|->     local ctrname=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   98|       local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   99|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fb334c6585aec2df5293b9a34110d128305c0417",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/080-pause.bats",
                    "line": 98,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   96|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   97|       local ctrname=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   98|->     local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   99|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  100|       run_podman run -d --name $ctrname     \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fc3b26ee2705ccf53209183120bdcfc8e8d969a4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman events functionality",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4c8a64b056977241ca8c3cad7761804e32f212b3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 321,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  319|   @test \"events - labels included in container die\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  320|       skip_if_remote \"remote does not support --events-backend\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|->     local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  322|       local lname=label$(safename | tr -d -)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  323|       local lvalue=\"labelvalue-$(safename) $(random_string 5)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f9eef8079fd629cc0f4e49dab837920ff381dab9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 322,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  320|       skip_if_remote \"remote does not support --events-backend\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|       local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  322|->     local lname=label$(safename | tr -d -)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  323|       local lvalue=\"labelvalue-$(safename) $(random_string 5)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  324|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "efce7622af9f845e90a161689ae68d3d205130d9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 323,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|       local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  322|       local lname=label$(safename | tr -d -)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  323|->     local lvalue=\"labelvalue-$(safename) $(random_string 5)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  324|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  325|       run_podman 17 --events-backend=file run --rm \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "870518933cbd4030681ac1d91cb693e6df867fa4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 355,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  353|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  354|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  355|->     local cname=c-$1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  356|       t0=$(date --iso-8601=seconds)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  357|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4c8a64b056977241ca8c3cad7761804e32f212b3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 410,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  408|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  409|   @test \"events - docker compat\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  410|->     local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  411|       t0=$(date --iso-8601=ns)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  412|       run_podman run --name=$cname --rm $IMAGE true",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b71ef83f598e623626d99acdaea7d759652aa8d3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/090-events.bats",
                    "line": 423,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  421|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  422|   @test \"events - volume events\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  423|->     local vname=v-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  424|       run_podman volume create $vname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  425|       run_podman volume rm $vname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "587dd79805fd544d08becdd8021e34299df316a5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/120-load.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman load",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b6dd7f26d546e59ecf40b4d0066216d83bfb8352",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/120-load.bats",
                    "line": 56,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|   @test \"podman save to pipe and load\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|       # Generate a random name and tag (must be lower-case)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|->     local random_name=x0$(random_string 12 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|       local random_tag=t0$(random_string 7 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   58|       local fqin=localhost/$random_name:$random_tag",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ba3c04dfc0989bc9a42f3be257d5eccb109923ad",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/120-load.bats",
                    "line": 57,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|       # Generate a random name and tag (must be lower-case)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|       local random_name=x0$(random_string 12 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|->     local random_tag=t0$(random_string 7 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   58|       local fqin=localhost/$random_name:$random_tag",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   59|       run_podman tag $IMAGE $fqin",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9963b3885cc80888f2ff516ce5d18dbc1b30df33",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/120-load.bats",
                    "line": 64,
                    "column": 14,
                    "h_size": 19,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   62|       # included a capital letter",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   63|       archive=$PODMAN_TMPDIR/MySubDirWithCaps/MyImage-$(random_string 8).tar",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   64|->     mkdir -p $(dirname $archive)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   65|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   66|       # We can't use run_podman because that uses the BATS 'run' function",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eb5fceb47fc15a2d2a07a799dd0b337245b480d9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/120-load.bats",
                    "line": 108,
                    "column": 9,
                    "h_size": 6,
                    "event": "warning[SC2034]",
                    "message": "whoami appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  106|       else",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  107|           # Harder: our CI infrastructure needs to define this & set up the acct",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  108|->         whoami=root",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  109|           notme=${PODMAN_ROOTLESS_USER}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  110|           if [[ -z \"$notme\" ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "38d6192667c653c2ee820b62a8c0b901cfe500e7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/120-load.bats",
                    "line": 150,
                    "column": 26,
                    "h_size": 11,
                    "event": "warning[SC2154]",
                    "message": "src_digest is referenced but not assigned (did you mean 'src_digests'?).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  148|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  149|       run_podman image inspect --format '{{.Digest}}' foobar:123",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  150|->     assert \"$output\" =~ \"$src_digest\" \"Digest of re-fetched image is in list of original image digests\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  151|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  152|       # remove root img for transfer back with another name",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f95b7732a42060a8b4dd3f7d5fb59d35057d5541",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/125-import.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman import",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d307438e96b20e98c52fcee857851fe7810ffdde",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/125-import.bats",
                    "line": 11,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    9|   @test \"podman import\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   10|       local archive=$PODMAN_TMPDIR/archive.tar",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|->     local random_content=$(random_string 12)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|       # Generate a random name and tag (must be lower-case)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|       local random_name=x0$(random_string 12 | tr A-Z a-z)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "bb56c3b61fbea4bbba680f2c6859cfb7447d1909",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/125-import.bats",
                    "line": 13,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|       local random_content=$(random_string 12)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|       # Generate a random name and tag (must be lower-case)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|->     local random_name=x0$(random_string 12 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|       local random_tag=t0$(random_string 7 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|       local fqin=localhost/$random_name:$random_tag",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1d7dacc6f21688f5903eedbfcf3a09f9cacfde49",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/125-import.bats",
                    "line": 14,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|       # Generate a random name and tag (must be lower-case)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|       local random_name=x0$(random_string 12 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|->     local random_tag=t0$(random_string 7 | tr A-Z a-z)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|       local fqin=localhost/$random_name:$random_tag",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   16|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3a30b84e8e011f9202fb8dac9642aa20a9f9c2e1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman kill",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "198f8e137b90e6e76e1d655b50d9ebe6220a0510",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 10,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    8|   # bats test_tags=distro-integration, ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    9|   @test \"podman kill - test signal handling in containers\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   10|->     local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|       local fifo=${PODMAN_TMPDIR}/podman-kill-fifo.$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|       mkfifo $fifo",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "07407d8aa1fa2e41ddaa706f36644267b21029b7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 11,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    9|   @test \"podman kill - test signal handling in containers\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   10|       local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|->     local fifo=${PODMAN_TMPDIR}/podman-kill-fifo.$(random_string 10)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|       mkfifo $fifo",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cc1b9210b8eece233ee81ab9a1b86c650658e736",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 61,
                    "column": 20,
                    "event": "warning[SC1010]",
                    "message": "Use semicolon or linefeed before 'done' (or quote to make it literal).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   59|       # could get caught and killed by cleanup, causing this step to exit 137",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   60|       run_podman exec -d $cname touch /stop",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   61|->     read -t 5 -u 5 done || die \"Timed out waiting for DONE from container\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   62|       is \"$done\" \"DONE\" \"final log message from container\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   63|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7f7cea08bc1709943b937eaba3e852af415b39a2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 73,
                    "column": 14,
                    "h_size": 22,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   71|       # These errors are thrown by the imported docker/signal.ParseSignal()",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   72|       local -a bad_signal_names=(0 SIGBADSIG SIG BADSIG %% ! \"''\" '\"\"' \" \")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   73|->     for s in ${bad_signal_names[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   74|           # 'nosuchcontainer' is fine: podman should bail before it gets there",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   75|           run_podman 125 kill -s $s nosuchcontainer",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b82a4b77af16889b8eaa6fed7486a954d01b4f85",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 86,
                    "column": 14,
                    "h_size": 22,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   84|       # error message doesn't include the dash.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   85|       local -a bad_dash_signals=(-0 -SIGBADSIG -SIG -BADSIG -)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   86|->     for s in ${bad_dash_signals[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   87|           run_podman 125 kill -s $s nosuchcontainer",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   88|           is \"$output\" \"Error: invalid signal: ${s##-}\" \"Error from kill -s $s\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fad9a6b779434a72b1b943e00d9610a98600f06d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/130-kill.bats",
                    "line": 93,
                    "column": 14,
                    "h_size": 21,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   91|       # This error (signal out of range) is thrown by our wrapper",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   92|       local -a bad_signal_nums=(65 -65 96 999 99999999)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   93|->     for s in ${bad_signal_nums[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   94|           run_podman 125 kill -s $s nosuchcontainer",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   95|           is \"$output\" \"Error: valid signals are 1 through 64\" \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "529846100a2ff31bede32308055cfbbbca580bec",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/140-diff.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for podman diff",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "96a70cc7b6e66104913b4e3344a1b2a96ab9e483",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/140-diff.bats",
                    "line": 27,
                    "column": 18,
                    "h_size": 13,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   25|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   27|->     for field in ${!expect[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   28|           # ARGH! The /sys/fs kludgery is for RHEL8 rootless, which mumble mumble",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   29|           # does some sort of magic muckery with /sys - I think the relevant",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "96a70cc7b6e66104913b4e3344a1b2a96ab9e483",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/140-diff.bats",
                    "line": 54,
                    "column": 18,
                    "h_size": 13,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   52|       )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   53|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|->     for field in ${!expect[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|           result=$(jq -r -c \".${field}[]\" <<<\"$output\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|           is \"$result\" \"${expect[$field]}\" \"$field\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "07a970973351b6e07dba752c6c359ae2ab24fa21",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/150-login.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman login",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f29f3ddad0d5d6bb5b3dafb53a2a1a6d09891c03",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/150-login.bats",
                    "line": 344,
                    "column": 28,
                    "h_size": 4,
                    "event": "warning[SC2154]",
                    "message": "mid is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  342|       run_podman tag $IMAGE $image1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  343|       run_podman push --authfile=$authfile \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  344|->         --tls-verify=false $mid \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  345|           $image1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       run_podman rmi $image1",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4e9435abf282247b084e8172ebd9072029110f90",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/150-login.bats",
                    "line": 348,
                    "column": 39,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       run_podman rmi $image1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|->     run_podman images $IMAGE --format {{.ID}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|       local podman_image_id=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  350|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4e9435abf282247b084e8172ebd9072029110f90",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/150-login.bats",
                    "line": 348,
                    "column": 40,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       run_podman rmi $image1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|->     run_podman images $IMAGE --format {{.ID}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|       local podman_image_id=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  350|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "314efedeeac5edbd422a9e3badd1fc3d0c8842d2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/150-login.bats",
                    "line": 348,
                    "column": 44,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       run_podman rmi $image1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|->     run_podman images $IMAGE --format {{.ID}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|       local podman_image_id=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  350|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "314efedeeac5edbd422a9e3badd1fc3d0c8842d2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/150-login.bats",
                    "line": 348,
                    "column": 45,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       run_podman rmi $image1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|->     run_podman images $IMAGE --format {{.ID}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|       local podman_image_id=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  350|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3380976d9a2ea752bd0a565fe4a58e901027c54c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/155-partial-pull.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman partial pulls support",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "47c0a17d5cd97c29e5bd2221db7fec30155cecae",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/155-partial-pull.bats",
                    "line": 146,
                    "column": 15,
                    "h_size": 168,
                    "event": "warning[SC2089]",
                    "message": "Quotes/backslashes will be treated literally. Use an array.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  144|   function dir_digest() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  145|       # inspired on https://www.gnu.org/software/tar/manual/html_node/Reproducibility.html",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  146|->     TARFLAGS=\"--numeric-owner --sort=name --format=posix --pax-option=exthdr.name=%d/PaxHeaders/%f --pax-option=delete=atime,delete=ctime --clamp-mtime --mtime='1970-01-01T01:01:01Z'\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  147|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  148|       tardest=$PODMAN_TMPDIR/tmp.tar",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "49f6df5e0dd4dee8cc590467e6b991a65e2169ad",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/155-partial-pull.bats",
                    "line": 150,
                    "column": 35,
                    "h_size": 9,
                    "event": "warning[SC2090]",
                    "message": "Quotes/backslashes in this variable will not be respected.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  148|       tardest=$PODMAN_TMPDIR/tmp.tar",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  149|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  150|->     run -0 tar -C $1 -cf $tardest $TARFLAGS .",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  151|       run -0 sha256sum < $tardest",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  152|       last_dir_digest=$(echo $output | tr -d ' -')",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e959d797eab6e0268ff16a2a474447dc5b3c951f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # podman volume-related tests",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1f4a4de8f0eaf35ade987e99f39f8744794323de",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 36,
                    "column": 10,
                    "h_size": 16,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   34|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   35|       # In each directory, write a random string to a file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   36|->     echo $(random_string) >$vol1/file1_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   37|       echo $(random_string) >$vol2/file2_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   38|       echo $(random_string) >$vol3/file3_in",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0cce9b15dd5d52beb132b0d4a5acbd433a78e30d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 37,
                    "column": 10,
                    "h_size": 16,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   35|       # In each directory, write a random string to a file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   36|       echo $(random_string) >$vol1/file1_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   37|->     echo $(random_string) >$vol2/file2_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   38|       echo $(random_string) >$vol3/file3_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   39|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "11c485560b49136192057786d63a8a62c3853eda",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 38,
                    "column": 10,
                    "h_size": 16,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   36|       echo $(random_string) >$vol1/file1_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   37|       echo $(random_string) >$vol2/file2_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   38|->     echo $(random_string) >$vol3/file3_in",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   39|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   40|       # Run 'cat' on each file, and compare against local files. Mix -v / --volume",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7a8ede56624dab508bcfa863c85d026750cb4caa",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 48,
                    "column": 41,
                    "h_size": 7,
                    "event": "warning[SC2154]",
                    "message": "voldir is referenced but not assigned (did you mean 'myvoldir'?).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   46|       for i in 1 2 3; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   47|           eval voldir=\\$vol${i}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   48|->         is \"${lines[$(($i - 1))]}\" \"$(< $voldir/file${i}_in)\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   49|              \"contents of /vol${i}/file${i}_in\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   50|       done",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "85b015ce1e1c3576c22a5ec4683644d24f127271",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 265,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  263|       skip_if_remote \"N/A on podman-remote\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  264|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  265|->     local volname=\"myvol_$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  266|       local mountpoint=\"/data$(random_string 8)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  267|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "57806c87a78d00ef1ce85b9a767a7b4d8c195234",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 266,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  264|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  265|       local volname=\"myvol_$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  266|->     local mountpoint=\"/data$(random_string 8)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  267|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  268|       run_podman volume create $volname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cd399d7c1b72c56933a7d80347f3db8da1431b39",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 271,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  269|       assert \"$output\" == \"$volname\" \"volume create emits the name it was given\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  270|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  271|->     local content=\"mycontent-$(random_string 20)-the-end\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  272|       run_podman run --rm --volume \"$volname:$mountpoint\" $IMAGE \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|                  sh -c \"echo $content >$mountpoint/testfile\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5bdffa00a0ce35a03eacb917b8a3064580f3b70b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 386,
                    "column": 16,
                    "h_size": 26,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  384|       # List available volumes for pruning after using 1,2,3",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  385|       run_podman volume prune <<< N",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  386|->     is \"$(echo $(sort <<<${lines[*]:1:3}))\" \"${v[4]} ${v[5]} ${v[6]}\" \"volume prune, with 1,2,3 in use, lists 4,5,6\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  387|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  388|       # List available volumes for pruning after using 1,2,3 and filtering; see #8913",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7a36d97dd6bd0114e1db2c81f5b47962784209e0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 386,
                    "column": 26,
                    "h_size": 15,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  384|       # List available volumes for pruning after using 1,2,3",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  385|       run_podman volume prune <<< N",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  386|->     is \"$(echo $(sort <<<${lines[*]:1:3}))\" \"${v[4]} ${v[5]} ${v[6]}\" \"volume prune, with 1,2,3 in use, lists 4,5,6\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  387|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  388|       # List available volumes for pruning after using 1,2,3 and filtering; see #8913",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4f6304d0c62a3aac4b3f128e4d54dd02b7af7455",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 390,
                    "column": 16,
                    "h_size": 26,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  388|       # List available volumes for pruning after using 1,2,3 and filtering; see #8913",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  389|       run_podman volume prune --filter label=mylabel <<< N",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  390|->     is \"$(echo $(sort <<<${lines[*]:1:2}))\" \"${v[5]} ${v[6]}\" \"volume prune, with 1,2,3 in use and 4 filtered out, lists 5,6\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  391|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  392|       # prune should remove v4",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "805eb3d96bd63b08e66eaa80db2f2b5556f90ced",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 390,
                    "column": 26,
                    "h_size": 15,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  388|       # List available volumes for pruning after using 1,2,3 and filtering; see #8913",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  389|       run_podman volume prune --filter label=mylabel <<< N",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  390|->     is \"$(echo $(sort <<<${lines[*]:1:2}))\" \"${v[5]} ${v[6]}\" \"volume prune, with 1,2,3 in use and 4 filtered out, lists 5,6\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  391|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  392|       # prune should remove v4",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b92cb336214ccf31b76640fac2a9d782d59f8884",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 394,
                    "column": 16,
                    "h_size": 18,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  392|       # prune should remove v4",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  393|       run_podman volume prune --force",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  394|->     is \"$(echo $(sort <<<$output))\" \"${v[4]} ${v[5]} ${v[6]}\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  395|          \"volume prune, with 1, 2, 3 in use, deletes only 4, 5, 6\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  396|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0042d25a02a520d447c056bd691cf678a84f4d72",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 401,
                    "column": 16,
                    "h_size": 18,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  399|       run_podman rm c2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  400|       run_podman volume prune --force",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  401|->     is \"$(echo $(sort <<<$output))\" \"${v[2]} ${v[3]}\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  402|          \"volume prune, after rm c2, deletes volumes 2 and 3\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  403|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "41717f8b86d71f7a6780d9b00641cf77519431b0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 539,
                    "column": 30,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|       # the HEX filesystem type (%t); readable one (%T) is for ease of debugging.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  538|       # We can't compare %T because our alpine-based testimage doesn't grok btrfs.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|->     run_podman info --format {{.Store.GraphRoot}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  540|       hostfs=$(stat -f -c '%t %T' $output)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  541|       echo \"# for debug: stat( $output ) = '$hostfs'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "41717f8b86d71f7a6780d9b00641cf77519431b0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 539,
                    "column": 31,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|       # the HEX filesystem type (%t); readable one (%T) is for ease of debugging.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  538|       # We can't compare %T because our alpine-based testimage doesn't grok btrfs.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|->     run_podman info --format {{.Store.GraphRoot}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  540|       hostfs=$(stat -f -c '%t %T' $output)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  541|       echo \"# for debug: stat( $output ) = '$hostfs'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "00c343bc928c2cdc8bb8ce06846cbfa95c60559c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 539,
                    "column": 48,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|       # the HEX filesystem type (%t); readable one (%T) is for ease of debugging.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  538|       # We can't compare %T because our alpine-based testimage doesn't grok btrfs.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|->     run_podman info --format {{.Store.GraphRoot}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  540|       hostfs=$(stat -f -c '%t %T' $output)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  541|       echo \"# for debug: stat( $output ) = '$hostfs'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "00c343bc928c2cdc8bb8ce06846cbfa95c60559c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 539,
                    "column": 49,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|       # the HEX filesystem type (%t); readable one (%T) is for ease of debugging.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  538|       # We can't compare %T because our alpine-based testimage doesn't grok btrfs.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|->     run_podman info --format {{.Store.GraphRoot}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  540|       hostfs=$(stat -f -c '%t %T' $output)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  541|       echo \"# for debug: stat( $output ) = '$hostfs'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f1c72f7b5d7ef56afe7ca7ae93e382c384141c98",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 599,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  597|       local user_id=2000",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  598|       local group_id=2000",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  599|->     local volume_name=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  600|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  601|       # Create a volume and get its mount point",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f34e755d1552e50d6bfa2bc41cf8cad826d0ca96",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/160-volumes.bats",
                    "line": 610,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  608|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  609|       # Podman chowns the mount point according to the user used in the previous command",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  610|->     local original_owner=$(stat --format %g:%u ${mountpoint})",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  611|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  612|       # Creating an existing volume with ignore should be a noop",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e123f1f85d7093828261b6ad6bb6f95d2a2166db",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/161-volume-quotas.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # podman volume XFS quota tests",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "92b31145798c3dfe61f884773ec349b506fb2db9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/170-run-userns.bats",
                    "line": 155,
                    "column": 36,
                    "h_size": 11,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  153|   @test \"podman userns=keep-id in a pod\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  154|       user=$(id -u)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  155|->     run_podman pod create --name p_$(safename) --userns keep-id",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  156|       pid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  157|       run_podman run --rm --pod $pid $IMAGE id -u",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cfbcdfe986abe36f7e60fdef02544f873210bd4f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/180-blkio.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # podman blkio-related tests",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8fc57c1df14c27a67c39451b7d2bcea0a6c929e6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/180-blkio.bats",
                    "line": 45,
                    "column": 32,
                    "h_size": 23,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   43|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   44|       # use bfq io scheduler",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   45|->     run grep -w bfq /sys/block/$(basename ${lodevice})/queue/scheduler",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   46|       if [ $status -ne 0 ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   47|           skip \"BFQ scheduler is not supported on the system\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6f4deac03c5916d22a6a781cd25b87fbd2374ef7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/180-blkio.bats",
                    "line": 49,
                    "column": 27,
                    "h_size": 23,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   47|           skip \"BFQ scheduler is not supported on the system\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   48|       fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   49|->     echo bfq > /sys/block/$(basename ${lodevice})/queue/scheduler",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   50|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   51|       # run podman",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3d5b3f1ee544e2f15a8014cf6281e88ae39c52d8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/180-blkio.bats",
                    "line": 63,
                    "column": 14,
                    "h_size": 17,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   61|               skip \"Kernel does not support BFQ IO scheduler\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   62|           fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   63|->         if [ $(podman_runtime) = \"crun\" ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   64|               # As of crun 1.2, crun doesn't support blkio.bfq.weight_device",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   65|               skip \"crun doesn't support blkio.bfq.weight_device\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "501233332512423de763170720a497b743fcdf92",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/195-run-namespaces.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for the namespace options",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1aa874b70d04068623ca5ece8805e954819cbdf7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/195-run-namespaces.bats",
                    "line": 21,
                    "column": 19,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   19|       for nstype in private host; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   20|           while read name option; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   21|->             local cname=\"c-${name}-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   22|               # ipc is special, private does not allow joining from another container.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   23|               # Instead we must use \"shareable\".",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7e126a4d74a18bdb1bccd21135cdf77478c8ab82",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 193,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  191|   # Generate the address IN CAPS (A-F), but we will test it in lowercase.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  192|   function random_mac() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  193|->     local mac=$(printf \"%02X\" $(( $(octet) & 242 | 2 )) )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  194|       for i in $(seq 2 6); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  195|           mac+=$(printf \":%02X\" $(octet))",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "75c0f0e5de7ba04fb980441a5c779eb0d91b88a4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 195,
                    "column": 31,
                    "h_size": 8,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  193|       local mac=$(printf \"%02X\" $(( $(octet) & 242 | 2 )) )",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  194|       for i in $(seq 2 6); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  195|->         mac+=$(printf \":%02X\" $(octet))",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  196|       done",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  197|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7927f5d32641552ae17bf5bc2757eade359a12ee",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 205,
                    "column": 28,
                    "h_size": 8,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  203|       local ip=\"172.20\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  204|       for i in 1 2;do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  205|->         ip+=$(printf \".%d\" $(octet))",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  206|       done",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  207|       echo $ip",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "87b986b353680230b7487165815827f1204c49e3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 241,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  239|       # existing 'pause' script in our testimage. We assign a bogus",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  240|       # entrypoint to confirm that --infra-command will override.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  241|->     local infra_image=\"infra_image_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  242|       local infra_command=\"/pause_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  243|       local infra_name=\"infra_container_$(safename)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "95ec3bcc27a35167c388af8fce48a28225202d33",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 242,
                    "column": 11,
                    "h_size": 13,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  240|       # entrypoint to confirm that --infra-command will override.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  241|       local infra_image=\"infra_image_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  242|->     local infra_command=\"/pause_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  243|       local infra_name=\"infra_container_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  244|       # --layers=false needed to work around buildah#5674 parallel flake",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "21cf83301ae1737079d3a502314a7ab6afe61769",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 243,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  241|       local infra_image=\"infra_image_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  242|       local infra_command=\"/pause_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  243|->     local infra_name=\"infra_container_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  244|       # --layers=false needed to work around buildah#5674 parallel flake",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  245|       run_podman build -t $infra_image --layers=false - << EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9101bd0f658a4733a1d33d9d3f76599a4cd728e2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 251,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  249|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  250|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  251|->     local podname=\"pod-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  252|       if is_rootless; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  253|           mac_option=",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1563d26ecf1d2422bfd2693cdeab8089c3ae1d0a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 296,
                    "column": 21,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  294|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  295|       run_podman run --rm --pod $pod_id $IMAGE cat /etc/hosts",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  296|->     is \"$output\" \".*$add_host_ip[[:blank:]]$add_host_n\" \"--add-host was added\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  297|       is \"$output\" \".*\t$hostname\"            \"--hostname is in /etc/hosts\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  298|       #               ^^^^ this must be a tab, not a space",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "21cf83301ae1737079d3a502314a7ab6afe61769",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 365,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  363|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  364|   @test \"podman pod create should fail when infra-name is already in use\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  365|->     local infra_name=\"infra_container_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  366|       local infra_image=\"quay.io/libpod/k8s-pause:3.5\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  367|       local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "85dde8d05c500b1eed0587625a8b8394c24754c5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 367,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  365|       local infra_name=\"infra_container_$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  366|       local infra_image=\"quay.io/libpod/k8s-pause:3.5\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  367|->     local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  368|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  369|       run_podman --noout pod create --name $pod_name --infra-name \"$infra_name\" --infra-image \"$infra_image\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "85dde8d05c500b1eed0587625a8b8394c24754c5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 382,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  380|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  381|   @test \"podman pod create --share\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  382|->     local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  383|       run_podman 125 pod create --share bogus --name $pod_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  384|       is \"$output\" \".*invalid kernel namespace to share: bogus. Options are: cgroup, ipc, net, pid, uts or none\" \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "85dde8d05c500b1eed0587625a8b8394c24754c5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 402,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  400|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  401|   @test \"podman pod create --pod new:$POD --hostname\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  402|->     local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  403|       run_podman run --rm --pod \"new:$pod_name\" --hostname foobar $IMAGE hostname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  404|       is \"$output\" \"foobar\" \"--hostname should work when creating a new:pod\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "85dde8d05c500b1eed0587625a8b8394c24754c5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 413,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  411|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  412|   @test \"podman rm --force to remove infra container\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  413|->     local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  414|       run_podman create --pod \"new:$pod_name\" $IMAGE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  415|       container_ID=\"$output\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 451,
                    "column": 46,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  449|       podname=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  450|       run_podman pod create --name $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  451|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  452|       is \"$output\" \"false\" \"Default network sharing should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  453|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 451,
                    "column": 47,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  449|       podname=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  450|       run_podman pod create --name $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  451|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  452|       is \"$output\" \"false\" \"Default network sharing should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  453|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 451,
                    "column": 72,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  449|       podname=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  450|       run_podman pod create --name $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  451|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  452|       is \"$output\" \"false\" \"Default network sharing should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  453|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 451,
                    "column": 73,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  449|       podname=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  450|       run_podman pod create --name $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  451|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  452|       is \"$output\" \"false\" \"Default network sharing should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  453|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 456,
                    "column": 46,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  454|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  455|       run_podman pod create --share ipc  --network private $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  457|       is \"$output\" \"false\" \"Private network sharing with only ipc should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 456,
                    "column": 47,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  454|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  455|       run_podman pod create --share ipc  --network private $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  457|       is \"$output\" \"false\" \"Private network sharing with only ipc should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 456,
                    "column": 72,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  454|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  455|       run_podman pod create --share ipc  --network private $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  457|       is \"$output\" \"false\" \"Private network sharing with only ipc should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 456,
                    "column": 73,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  454|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  455|       run_podman pod create --share ipc  --network private $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  457|       is \"$output\" \"false\" \"Private network sharing with only ipc should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 461,
                    "column": 46,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  460|       run_podman pod create --name $podname --share net  --network private",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  461|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  462|       is \"$output\" \"false\" \"Private network sharing with only net should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 461,
                    "column": 47,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  460|       run_podman pod create --name $podname --share net  --network private",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  461|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  462|       is \"$output\" \"false\" \"Private network sharing with only net should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 461,
                    "column": 72,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  460|       run_podman pod create --name $podname --share net  --network private",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  461|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  462|       is \"$output\" \"false\" \"Private network sharing with only net should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 461,
                    "column": 73,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  460|       run_podman pod create --name $podname --share net  --network private",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  461|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  462|       is \"$output\" \"false\" \"Private network sharing with only net should be false\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 465,
                    "column": 46,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  464|       run_podman pod create --share net --network host --replace $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  465|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  466|       is \"$output\" \"true\" \"Host network sharing with only net should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  467|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 465,
                    "column": 47,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  464|       run_podman pod create --share net --network host --replace $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  465|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  466|       is \"$output\" \"true\" \"Host network sharing with only net should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  467|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 465,
                    "column": 72,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  464|       run_podman pod create --share net --network host --replace $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  465|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  466|       is \"$output\" \"true\" \"Host network sharing with only net should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  467|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 465,
                    "column": 73,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  463|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  464|       run_podman pod create --share net --network host --replace $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  465|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  466|       is \"$output\" \"true\" \"Host network sharing with only net should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  467|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 470,
                    "column": 46,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  468|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|       run_podman pod create --name $podname --share ipc --network host",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  470|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|       is \"$output\" \"true\" \"Host network sharing with only ipc should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d8c3c793632b1ca0697e71bd6a6188b313f063c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 470,
                    "column": 47,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  468|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|       run_podman pod create --name $podname --share ipc --network host",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  470|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|       is \"$output\" \"true\" \"Host network sharing with only ipc should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 470,
                    "column": 72,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  468|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|       run_podman pod create --name $podname --share ipc --network host",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  470|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|       is \"$output\" \"true\" \"Host network sharing with only ipc should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6bd12c07f5cb18864d98c14802793b9b76ea5047",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 470,
                    "column": 73,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  468|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|       run_podman pod create --name $podname --share ipc --network host",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  470|->     run_podman pod inspect $podname --format {{.InfraConfig.HostNetwork}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|       is \"$output\" \"true\" \"Host network sharing with only ipc should be true\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|       run_podman pod rm $podname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6f7cd651492952c6d41a0a7058dbedd130b771e7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 512,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  510|   @test \"pod exit policies - play kube\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  511|       # play-kube sets the exit policy to \"stop\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  512|->     local name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  513|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  514|       kubeFile=\"apiVersion: v1",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ac277770f2ccf284dfe69e032154f1ff485419ec",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 547,
                    "column": 32,
                    "h_size": 25,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  545|       # tr needed because losetup seems to use %2d",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  546|       lomajmin=$(losetup -l --noheadings --output MAJ:MIN $LOOPDEVICE | tr -d ' ')",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  547|->     run grep -w bfq /sys/block/$(basename ${LOOPDEVICE})/queue/scheduler",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  548|       if [ $status -ne 0 ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  549|           losetup -d $LOOPDEVICE",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "22b699067df5cb7fa1c9195af8fe5f314cae729a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 553,
                    "column": 27,
                    "h_size": 25,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  551|           skip \"BFQ scheduler is not supported on the system\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  552|       fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  553|->     echo bfq > /sys/block/$(basename ${LOOPDEVICE})/queue/scheduler",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  554|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  555|       # FIXME: #15464: blkio-weight-device not working",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cd0fdf62c628200f105a0dc7e5537767803db596",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 566,
                    "column": 15,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  564|       defer-assertion-failures",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  565|       for cgm in systemd cgroupfs; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  566|->         local name=\"p-resources-$cgm-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  567|           run_podman --cgroup-manager=$cgm pod create --name=$name --cpus=5 --memory=5m --memory-swap=1g --cpu-shares=1000 --cpuset-cpus=0 --cpuset-mems=0 --device-read-bps=${LOOPDEVICE}:1mb --device-write-bps=${LOOPDEVICE}:1mb --blkio-weight=50",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  568|           run_podman --cgroup-manager=$cgm pod start $name",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74fbd67c4b855c0d08c39c20f3568a6a327c778",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 573,
                    "column": 19,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  571|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  572|           while read unit expect; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  573|->             local actual=$(< /sys/fs/cgroup/$cgroup_path/$unit)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  574|               is \"$actual\" \"$expect\" \"resource limit under $cgm: $unit\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  575|           done < <(parse_table \"$expected_limits\")",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a491c04338bbc18828a043506420cfb736cc588c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 587,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "i appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  585|   @test \"podman pod ps doesn't race with pod rm\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  586|       # create a few pods",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  587|->     for i in {0..10}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  588|           run_podman pod create",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  589|       done",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "751075abc5e88e63a0a47b225b7521a52d05aaf1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 687,
                    "column": 31,
                    "h_size": 11,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  685|           podname=\"p-${p}-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  686|           thingy_with_unique_id \"pod\" \"--infra=false --name $podname\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  687|->                               ${podid[*]} ${ctrid[*]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  688|           podid[$p]=$id",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  689|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "751075abc5e88e63a0a47b225b7521a52d05aaf1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 687,
                    "column": 43,
                    "h_size": 11,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  685|           podname=\"p-${p}-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  686|           thingy_with_unique_id \"pod\" \"--infra=false --name $podname\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  687|->                               ${podid[*]} ${ctrid[*]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  688|           podid[$p]=$id",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  689|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "751075abc5e88e63a0a47b225b7521a52d05aaf1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 693,
                    "column": 35,
                    "h_size": 11,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  691|               thingy_with_unique_id \"container\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  692|                                     \"--pod $podname --name $podname-c${c} $IMAGE true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  693|->                                   ${podid[*]} ${ctrid[*]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  694|               ctrid[$p$c]=$id",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  695|           done",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "751075abc5e88e63a0a47b225b7521a52d05aaf1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 693,
                    "column": 47,
                    "h_size": 11,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  691|               thingy_with_unique_id \"container\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  692|                                     \"--pod $podname --name $podname-c${c} $IMAGE true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  693|->                                   ${podid[*]} ${ctrid[*]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  694|               ctrid[$p$c]=$id",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  695|           done",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "84d7c20e50bfa6221dc8e60a3437b48f557506ed",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 716,
                    "column": 15,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  714|       for p in 1 2 3; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  715|           local pid=${podid[$p]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  716|->         local podname=\"p-$p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  717|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  718|           # Search by short pod ID, longer pod ID, pod ID regex, and pod name",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "84d7c20e50bfa6221dc8e60a3437b48f557506ed",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 740,
                    "column": 19,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  738|           for c in 1 2 3;do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  739|               local cid=${ctrid[$p$c]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  740|->             local podname=\"p-$p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  741|               for filter in \"ctr-ids=${cid:0:2}\" \"ctr-ids=^${cid:0:2}.*\"; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  742|                   run_podman pod ps --filter=$filter --format '{{.Name}}:{{.Id}}'",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1e5097c889b4d77ef5ebcd93518bfae4e3454512",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 758,
                    "column": 26,
                    "h_size": 11,
                    "event": "warning[SC2048]",
                    "message": "Use \"${array[@]}\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  756|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  757|       # Clean up",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  758|->     run_podman pod rm -f ${podid[*]}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  759|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  760|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6beb19aa10a86903416d6ac630e3f6c4757612eb",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 769,
                    "column": 9,
                    "h_size": 5,
                    "event": "warning[SC2178]",
                    "message": "Variable was used as an array but is now assigned a string.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  767|       for infra in true false; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  768|           run_podman pod create --infra=$infra --memory=256M",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  769|->         podid=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  770|           run_podman run -d --pod $podid $IMAGE top -d 2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  771|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a8065c570916e8b6c26440d2acaccf317df9676a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 770,
                    "column": 33,
                    "h_size": 6,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  768|           run_podman pod create --infra=$infra --memory=256M",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  769|           podid=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  770|->         run_podman run -d --pod $podid $IMAGE top -d 2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  771|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  772|           run_podman pod inspect $podid --format \"{{.CgroupPath}}\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "374d4cab8b0027fe62843631355883e470d761aa",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 772,
                    "column": 32,
                    "h_size": 6,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  770|           run_podman run -d --pod $podid $IMAGE top -d 2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  771|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  772|->         run_podman pod inspect $podid --format \"{{.CgroupPath}}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  773|           result=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  774|           assert \"$result\" =~ \"/\" \".CgroupPath is a valid path\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "273002f83a5e100f672b3a7684a56720f3595378",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 786,
                    "column": 34,
                    "h_size": 6,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  784|           fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  785|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  786|->         run_podman pod stop -t 0 $podid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  787|           if test -e $cgroup_path; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  788|               die \"the cgroup $cgroup_path should not exist after pod stop\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8e4d0747ddab71af18553fc8417b9dad20c7db32",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 791,
                    "column": 30,
                    "h_size": 6,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  789|           fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  790|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  791|->         run_podman pod start $podid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  792|           if test ! -e $cgroup_path; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  793|               die \"the cgroup $cgroup_path does not exist\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 670,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f67f3c90e4e5067ebc86099363822294a71454a2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/200-pod.bats",
                    "line": 805,
                    "column": 35,
                    "h_size": 6,
                    "event": "warning[SC2128]",
                    "message": "Expanding an array without an index only gives the first element.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  803|           assert \"$(< $memory_limit_file)\" = \"268435456\" \"Contents of $memory_limit_file\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  804|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  805|->         run_podman pod rm -t 0 -f $podid",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  806|           if test -e $cgroup_path; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  807|               die \"the cgroup $cgroup_path should not exist after pod rm\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "740d27e58fa076ca2e34786952c56729cda7c917",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman healthcheck",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9aea1c711a2daec884c999d35bae638baebd2338",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 56,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   55|   @test \"podman healthcheck\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|       run_podman run -d --name $ctrname                  \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   58|                  --health-cmd /home/podman/healthcheck   \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eedf72220aa29fce6c1e086425fdb18b228790ce",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 257,
                    "column": 9,
                    "h_size": 2,
                    "event": "warning[SC2034]",
                    "message": "t0 appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  255|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  256|       for policy in stop kill restart ;do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  257|->         t0=$(date --iso-8601=seconds)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  258|           run_podman run -d --name $ctr      \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  259|                  --health-cmd /bin/false     \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "56fe4dcff1809812fb41c2d393e04523871a2f09",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 330,
                    "column": 15,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  328|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  329|       while read flag value op logs_count ; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  330|->         local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  331|           local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  332|           _create_container_with_health_log_settings $ctrname $msg \"{{.Config.HealthMaxLogCount}}\" $flag $value \"HealthMaxLogCount\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9aea1c711a2daec884c999d35bae638baebd2338",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 331,
                    "column": 15,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  329|       while read flag value op logs_count ; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  330|           local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  331|->         local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  332|           _create_container_with_health_log_settings $ctrname $msg \"{{.Config.HealthMaxLogCount}}\" $flag $value \"HealthMaxLogCount\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  333|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "93c9703b9c1af9e95f6c7540fced0eae8c996cbc",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 347,
                    "column": 11,
                    "h_size": 1,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  345|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|   @test \"podman healthcheck --health-max-log-size values\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|->     local s=$(printf \"healthmsg-%1000s\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|       local long_msg=${s// /$(random_string)}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d9c8462e9b5b30b269d49d6e72bf3add4610c0a3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 347,
                    "column": 22,
                    "h_size": 18,
                    "event": "warning[SC2183]",
                    "message": "This format string has 1 variable, but is passed 0 argument.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  345|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|   @test \"podman healthcheck --health-max-log-size values\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|->     local s=$(printf \"healthmsg-%1000s\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  348|       local long_msg=${s// /$(random_string)}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0a79ce2805adf5c4d39f67c1ba961882b86282d7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 351,
                    "column": 5,
                    "h_size": 4,
                    "event": "warning[SC2034]",
                    "message": "test appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  349|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  350|       # flag                    | expected value | exp_msg",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  351|->     test=\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  352|                                 | 500            | ${long_msg:0:500}}]\\$",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  353|       --health-max-log-size 0   | 0              | $long_msg}]\\$",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9aea1c711a2daec884c999d35bae638baebd2338",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 360,
                    "column": 15,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  358|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  359|       while read flag value exp_msg ; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  360|->         local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  361|           _create_container_with_health_log_settings $ctrname $long_msg \"{{.Config.HealthMaxLogSize}}\" $flag $value \"HealthMaxLogSize\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  362|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9aea1c711a2daec884c999d35bae638baebd2338",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 375,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  373|       local TMP_DIR_HEALTHCHECK=\"$PODMAN_TMPDIR/healthcheck\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  374|       mkdir $TMP_DIR_HEALTHCHECK",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  375|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  376|       local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  377|       _create_container_with_health_log_settings $ctrname $msg \"{{.Config.HealthLogDestination}}\" \"--health-log-destination $TMP_DIR_HEALTHCHECK\" \"$TMP_DIR_HEALTHCHECK\" \"HealthLogDestination\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "56fe4dcff1809812fb41c2d393e04523871a2f09",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 376,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  374|       mkdir $TMP_DIR_HEALTHCHECK",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  375|       local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  376|->     local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  377|       _create_container_with_health_log_settings $ctrname $msg \"{{.Config.HealthLogDestination}}\" \"--health-log-destination $TMP_DIR_HEALTHCHECK\" \"$TMP_DIR_HEALTHCHECK\" \"HealthLogDestination\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  378|       cid=\"$output\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9aea1c711a2daec884c999d35bae638baebd2338",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 399,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  397|       skip_if_journald_unavailable",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  398|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  399|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  400|       local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  401|       _create_container_with_health_log_settings $ctrname $msg \"{{.Config.HealthLogDestination}}\" \"--health-log-destination events_logger\" \"events_logger\" \"HealthLogDestination\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "56fe4dcff1809812fb41c2d393e04523871a2f09",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 400,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  398|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  399|       local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  400|->     local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  401|       _create_container_with_health_log_settings $ctrname $msg \"{{.Config.HealthLogDestination}}\" \"--health-log-destination events_logger\" \"events_logger\" \"HealthLogDestination\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  402|       cid=\"$output\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "629e9005fa0fe5b250f9cd099d8334547c3d94bb",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/220-healthcheck.bats",
                    "line": 443,
                    "column": 12,
                    "h_size": 14,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  441|       wait -n $hc_pid || rc=$?",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  442|       assert $rc -eq 1 \"exit status check of healthcheck command\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  443|->     assert $(< $hcStatus) == \"stopped\" \"Health status\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  444|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  445|       run_podman inspect $ctr --format \"{{.State.Status}}--{{.State.Health.Status}}--{{.State.Health.FailingStreak}}\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f52bd719020279ca094d7a9bf228174ce8acd5e0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/250-systemd.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests generated configurations for systemd.",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 252,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "de7969aa7d377988b2ed4f2566025a87728e9987",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/250-systemd.bats",
                    "line": 64,
                    "column": 9,
                    "h_size": 17,
                    "event": "warning[SC2164]",
                    "message": "Use 'cd ... || exit' or 'cd ... || return' in case cd fails.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   62|       # is forgiving about that, but RHEL8 systemd chokes with EINVAL)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   63|       (",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   64|->         cd $PODMAN_TMPDIR",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   65|           run_podman generate systemd --files --name \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   66|                  -e http_proxy -e https_proxy -e no_proxy \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 480,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a34d8bfe688b1f7c42ed0446c09795aef09a3084",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/250-systemd.bats",
                    "line": 306,
                    "column": 30,
                    "h_size": 1,
                    "event": "warning[SC1007]",
                    "message": "Remove space after = if trying to assign a value (for empty string, use var='' ... ).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  304|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  305|   @test \"podman --cgroup=cgroupfs doesn't show systemd warning\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  306|->     DBUS_SESSION_BUS_ADDRESS= run_podman --log-level warning --cgroup-manager=cgroupfs info -f ''",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  307|       is \"$output\" \"\" \"output should be empty\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  308|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6238960a67d2c32d1b9c4315a7b054ab8ae0face",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/250-systemd.bats",
                    "line": 331,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  329|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  330|       cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  331|->     local netname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  332|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  333|       # create network and container with network",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5783d22da01754347a46abd905c7bfe8696f1c12",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/250-systemd.bats",
                    "line": 490,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "i appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  488|       # Kill the pod and make sure the service is not running.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  489|       run_podman pod kill $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  490|->     for i in {0..20}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  491|           # echos are for debugging test flakes",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  492|           echo \"$_LOG_PROMPT systemctl is-active $service_name\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "bea55db688d2558f41ac68e8ee0c50e731f031e6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/251-system-service.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests that require 'podman system service' but no other systemd aspects",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "64b6352f4fde8d039ade0cecae0bace603834600",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/251-system-service.bats",
                    "line": 43,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   41|   @test \"podman-system-service containers survive service stop\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   42|       skip_if_remote \"podman system service unavailable over remote\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   43|->     local runtime=$(podman_runtime)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   44|       if [[ \"$runtime\" != \"crun\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   45|           skip \"survival code only implemented in crun; you're using $runtime\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "21275d9718940362ab58be54f45ad88a96d3c3fa",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests generated configurations for systemd.",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 88,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0eee18c9c95bc04faf2e26ba35507cded40e94ab",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 33,
                    "column": 22,
                    "h_size": 16,
                    "event": "error[SC2068]",
                    "message": "Double quote array expansions to avoid re-splitting elements.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   31|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   32|   function teardown() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   33|->     for UNIT_FILE in ${UNIT_FILES[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   34|           if [[ -e \"$UNIT_FILE\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   35|               local service=$(basename \"$UNIT_FILE\")",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3eb4fae807ac639d8654802bfa17570a63a70777",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 35,
                    "column": 19,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   33|       for UNIT_FILE in ${UNIT_FILES[@]}; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   34|           if [[ -e \"$UNIT_FILE\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   35|->             local service=$(basename \"$UNIT_FILE\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   36|               run systemctl stop \"$service\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   37|               if [ $status -ne 0 ]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ec95319962693dd0761bfb81aef7ae78694ef9f8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 52,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   50|   function run_quadlet() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   51|       local sourcefile=\"$1\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   52|->     local service=$(quadlet_to_service_name \"$sourcefile\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   53|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   54|       # quadlet always works on an entire directory, so copy the file",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f205d59fa8850a6019d6631fe9a597b3acd919c9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 138,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  136|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  137|   function create_secret() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  138|->     local secret_name=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  139|       local secret_file=$PODMAN_TMPDIR/secret_$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  140|       local secret=$(random_string)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9970fab84cb0dae861f2c2a8163510d4b24cc511",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 139,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  137|   function create_secret() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  138|       local secret_name=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  139|->     local secret_file=$PODMAN_TMPDIR/secret_$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  140|       local secret=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  141|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b5e0012b0366c9d36234fe7b72004c47b602b1cc",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 140,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  138|       local secret_name=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  139|       local secret_file=$PODMAN_TMPDIR/secret_$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  140|->     local secret=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  141|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  142|       echo $secret > $secret_file",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cb607cec912a5086583e2d2c7fbc80296ec2a6d0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 179,
                    "column": 28,
                    "h_size": 13,
                    "event": "warning[SC2076]",
                    "message": "Remove quotes from right-hand side of =~ to match as a regex rather than literally.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  177|       while [ \"$count\" -gt 0 ]; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  178|           run journalctl \"--since=$STARTED_TIME\" --unit=\"$QUADLET_SERVICE_NAME\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  179|->         if [[ \"$output\" =~ \"$expect_str\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  180|               return",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  181|           fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 192,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  190|       # Network=none is to work around a Pasta bug, can be removed once a patched Pasta is available.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  191|       # Ref https://github.com/containers/podman/pull/21563#issuecomment-1965145324",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  192|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  193|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  194|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "cca301678d1fffa000242c97cd96cce979ab59cf",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 240,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  238|       dir1=$PODMAN_TMPDIR/$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  239|       dir2=$PODMAN_TMPDIR/$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  240|->     local quadlet_file=basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  241|       mkdir -p $dir1 $dir2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  242|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4edf26a843ed93074d0a1d2f7d0ff50ac07736bc",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 262,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  260|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  261|   @test \"quadlet - envvar\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  262|->     local quadlet_file=$PODMAN_TMPDIR/envvar_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  263|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  264|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d635e2e1d4be978e8290fe25ee8323987d0ca1d7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 286,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  284|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  285|   @test \"quadlet - ContainerName and journal output check\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|->     local quadlet_file=$PODMAN_TMPDIR/containername_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|       local token_out=\"STDOUT$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|       local token_err=\"STDERR$(random_string 10)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "5513a1983132792ca331f1d5c91c0cebfcb4ee73",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 287,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  285|   @test \"quadlet - ContainerName and journal output check\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|       local quadlet_file=$PODMAN_TMPDIR/containername_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|->     local token_out=\"STDOUT$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|       local token_err=\"STDERR$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  289|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "321bff51d3ff513928e01b93b742b4d9f70dc355",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 288,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|       local quadlet_file=$PODMAN_TMPDIR/containername_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|       local token_out=\"STDOUT$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|->     local token_err=\"STDERR$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  289|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  290|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "80f58f17a124102eb150466367e4ebe1139d365d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 319,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  317|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  318|   @test \"quadlet - labels\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  319|->     local quadlet_file=$PODMAN_TMPDIR/labels_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  320|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "c76f86cc96df82a1c7823ca42410299c7c155483",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 345,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  343|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  344|   @test \"quadlet - oneshot\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  345|->     local quadlet_file=$PODMAN_TMPDIR/oneshot_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  346|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  347|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "460d8c31d0614ad28a553867743153aaadff705f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 368,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  366|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  367|   @test \"quadlet - volume\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  368|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  369|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  370|   [Volume]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "53847178015e852ef8bb7e8c90858bcf88232eee",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 378,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  376|       service_setup $QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  377|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  378|->     local volume_name=systemd-$(basename $quadlet_file .volume)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  379|       run_podman volume ls",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  380|       is \"$output\" \".*local.*${volume_name}.*\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "642e69e1eb77f1f6ba6efee5c4c40d24dd615292",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 394,
                    "column": 11,
                    "h_size": 16,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  392|   @test \"quadlet - volume dependency\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  393|       # Save the unit name to use as the volume for the container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  394|->     local quadlet_vol_unit=dep_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  395|       local quadlet_vol_file=$PODMAN_TMPDIR/${quadlet_vol_unit}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  396|       cat > $quadlet_vol_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4155b75162d0f0c3e475baedeb397a6af0886560",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 400,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  398|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  399|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  400|->     local quadlet_tmpdir=$(mktemp -d --tmpdir=$PODMAN_TMPDIR quadlet.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  401|       # Have quadlet create the systemd unit file for the volume unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  402|       run_quadlet \"$quadlet_vol_file\" \"$quadlet_tmpdir\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ba4383421c38f4d9049fd6380cf6c40230e589d8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 406,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  404|       # Save the volume service name since the variable will be overwritten",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  405|       local vol_service=$QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  406|->     local volume_name=systemd-$(basename $quadlet_vol_file .volume)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  407|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  408|       local quadlet_file=$PODMAN_TMPDIR/user_$(safename).container",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eb315e04285653c4e964401ccfaf074ec01a9a46",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 408,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  406|       local volume_name=systemd-$(basename $quadlet_vol_file .volume)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  407|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  408|->     local quadlet_file=$PODMAN_TMPDIR/user_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  409|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  410|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "392b1a70d8c529412b1848b0ae354800d94d124a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 443,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  441|   # A quadlet container depends on a named quadlet volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  442|   @test \"quadlet - named volume dependency\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  443|->     local volume_name=\"v-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  444|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  445|       # Save the unit name to use as the volume for the container",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "642e69e1eb77f1f6ba6efee5c4c40d24dd615292",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 446,
                    "column": 11,
                    "h_size": 16,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  444|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  445|       # Save the unit name to use as the volume for the container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  446|->     local quadlet_vol_unit=dep_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  447|       local quadlet_vol_file=$PODMAN_TMPDIR/${quadlet_vol_unit}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  448|       cat > $quadlet_vol_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4155b75162d0f0c3e475baedeb397a6af0886560",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 454,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  452|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  453|       # Have quadlet create the systemd unit file for the volume unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  454|->     local quadlet_tmpdir=$(mktemp -d --tmpdir=$PODMAN_TMPDIR quadlet.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  455|       run_quadlet \"$quadlet_vol_file\" \"$quadlet_tmpdir\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eb315e04285653c4e964401ccfaf074ec01a9a46",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 460,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|       local vol_service=$QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  460|->     local quadlet_file=$PODMAN_TMPDIR/user_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  461|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  462|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "914467ef125a0e1fb0fc40fd668d2c9b27eabd30",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 473,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|       # Save the container service name for readability",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|       local container_service=$QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  473|->     local container_name=systemd-$(basename $quadlet_file .container)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  474|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  475|       # Volume should not exist",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "00a7e4748079e0d9b29ae9e7dd86dfff873c6582",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 498,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  496|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  497|   @test \"quadlet - network\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  498|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  499|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  500|   [Network]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2c555b12b98a80d06532494a96350668b599e6c2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 508,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  506|       service_setup $QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  507|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  508|->     local network_name=systemd-$(basename $quadlet_file .network)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  509|       run_podman network exists $network_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  510|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "076b374dfc46c975223a27583e4634b896ff3052",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 523,
                    "column": 11,
                    "h_size": 20,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  521|   @test \"quadlet - network dependency\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  522|       # Save the unit name to use as the network for the container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  523|->     local quadlet_network_unit=dep_$(safename).network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  524|       local quadlet_network_file=$PODMAN_TMPDIR/${quadlet_network_unit}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  525|       cat > $quadlet_network_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4155b75162d0f0c3e475baedeb397a6af0886560",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 529,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  527|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  528|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  529|->     local quadlet_tmpdir=$(mktemp -d --tmpdir=$PODMAN_TMPDIR quadlet.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  530|       # Have quadlet create the systemd unit file for the network unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  531|       run_quadlet \"$quadlet_network_file\" \"$quadlet_tmpdir\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "bd14fc4d046670fa650619edbf4252c718450064",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 535,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  533|       # Save the volume service name since the variable will be overwritten",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  534|       local network_service=$QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  535|->     local network_name=systemd-$(basename $quadlet_network_file .network)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  536|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|       local quadlet_file=$PODMAN_TMPDIR/user_$(safename).container",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eb315e04285653c4e964401ccfaf074ec01a9a46",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 537,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  535|       local network_name=systemd-$(basename $quadlet_network_file .network)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  536|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  537|->     local quadlet_file=$PODMAN_TMPDIR/user_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  538|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  539|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "076b374dfc46c975223a27583e4634b896ff3052",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 570,
                    "column": 11,
                    "h_size": 20,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  568|   @test \"quadlet - named network dependency\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  569|       # Save the unit name to use as the network for the container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  570|->     local quadlet_network_unit=dep_$(safename).network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  571|       local quadlet_network_file=$PODMAN_TMPDIR/${quadlet_network_unit}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  572|       cat > $quadlet_network_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4155b75162d0f0c3e475baedeb397a6af0886560",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 578,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  576|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  577|       # Have quadlet create the systemd unit file for the network unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  578|->     local quadlet_tmpdir=$(mktemp -d --tmpdir=$PODMAN_TMPDIR quadlet.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  579|       run_quadlet \"$quadlet_network_file\" \"$quadlet_tmpdir\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  580|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eb315e04285653c4e964401ccfaf074ec01a9a46",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 585,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  583|       local network_name=\"foo\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  584|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  585|->     local quadlet_file=$PODMAN_TMPDIR/user_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  586|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  587|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "914467ef125a0e1fb0fc40fd668d2c9b27eabd30",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 597,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  595|       # Save the container service name for readability",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  596|       local container_service=$QUADLET_SERVICE_NAME",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  597|->     local container_name=systemd-$(basename $quadlet_file .container)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  598|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  599|       # Network should not exist",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4c14d5ce5e17ef4377b174108c3ad04ef97005c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 643,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  641|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  642|       # Create the Quadlet file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  643|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  644|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  645|   [Kube]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "076b374dfc46c975223a27583e4634b896ff3052",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 663,
                    "column": 11,
                    "h_size": 20,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  661|   @test \"quadlet kube - named network dependency\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  662|       # Save the unit name to use as the network for the container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  663|->     local quadlet_network_unit=dep_$(safename).network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  664|       local quadlet_network_file=$PODMAN_TMPDIR/${quadlet_network_unit}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  665|       local network_name=\"n-$(safename)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0e521eb4731f3a7f5deb5e6acaa3091c26c7529f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 665,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  663|       local quadlet_network_unit=dep_$(safename).network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  664|       local quadlet_network_file=$PODMAN_TMPDIR/${quadlet_network_unit}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  665|->     local network_name=\"n-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  666|       cat > $quadlet_network_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  667|   [Network]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4155b75162d0f0c3e475baedeb397a6af0886560",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 672,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  670|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  671|       # Have quadlet create the systemd unit file for the network unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  672|->     local quadlet_tmpdir=$(mktemp -d --tmpdir=$PODMAN_TMPDIR quadlet.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  673|       run_quadlet \"$quadlet_network_file\" \"$quadlet_tmpdir\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  674|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4c14d5ce5e17ef4377b174108c3ad04ef97005c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 701,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  699|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  700|       # Create the Quadlet file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  701|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  702|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  703|   [Kube]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 746,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  744|       mountpoint=\"$output\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  745|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  746|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  747|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  748|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 767,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  765|   @test \"quadlet - selinux disable\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  766|       skip_if_no_selinux",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  767|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  768|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  769|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 790,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  788|       skip_if_no_selinux",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  789|       NAME=name$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  790|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  791|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  792|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 819,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  817|       create_secret",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  818|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  819|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  820|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  821|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 845,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  843|       create_secret",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  844|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  845|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  846|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  847|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "661c666dd9b22ab42e9882ae6a7675c19ca8d450",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 874,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  872|       # seem to be any systemctly way to find this.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  873|       percent_t_file=\"${PODMAN_TMPDIR}/foo\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  874|->     local service=get-percent-t.$(safename).service",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  875|       local unitfile=${UNIT_DIR}/$service",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  876|       cat >$unitfile <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "78cf0f8582e1556d4cc39e1577209d13aedb5388",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 894,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  892|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  893|       # Step 2: Make a subdirectory in %T, and in there, a scratch file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  894|->     local tmp_path=$(mktemp -d --tmpdir=${percent_t} quadlet.volume.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  895|       local tmp_subdir=$(basename $tmp_path)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  896|       local file_name=\"f$(random_string 10).txt\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7f4838c4355435c9127ed5da7a75359865388957",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 895,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  893|       # Step 2: Make a subdirectory in %T, and in there, a scratch file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  894|       local tmp_path=$(mktemp -d --tmpdir=${percent_t} quadlet.volume.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  895|->     local tmp_subdir=$(basename $tmp_path)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  896|       local file_name=\"f$(random_string 10).txt\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  897|       local file_content=\"data_$(random_string 15)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a3ea540110202028abd198cbf991070a87b20700",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 896,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  894|       local tmp_path=$(mktemp -d --tmpdir=${percent_t} quadlet.volume.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  895|       local tmp_subdir=$(basename $tmp_path)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  896|->     local file_name=\"f$(random_string 10).txt\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  897|       local file_content=\"data_$(random_string 15)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  898|       echo $file_content > $tmp_path/$file_name",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a1e2521009ff01c84cdc5f9993c6870c86eeab6c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 897,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  895|       local tmp_subdir=$(basename $tmp_path)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  896|       local file_name=\"f$(random_string 10).txt\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  897|->     local file_content=\"data_$(random_string 15)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  898|       echo $file_content > $tmp_path/$file_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  899|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 900,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  898|       echo $file_content > $tmp_path/$file_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  899|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  900|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  901|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  902|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 921,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  919|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  920|   @test \"quadlet - tmpfs\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  921|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  922|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  923|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d74f04b23738023df1c4446e5dbe7314baa066f3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 946,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  944|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  945|   @test \"quadlet - userns\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  946|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  947|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  948|   [Container]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b3fdc79d20216357b0d1016e2bf73794673a1566",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 972,
                    "column": 13,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  970|   \"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  971|      while read exit_code_prop cmd exit_code service_state; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  972|->       local basename=propagate-${exit_code_prop}-${cmd}_$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  973|         local quadlet_file=$PODMAN_TMPDIR/$basename.kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  974|         local yaml_file=$PODMAN_TMPDIR/$basename.yaml",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "29abed547c13a7bb27423c1ddb2e9864ab47822a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1011,
                    "column": 30,
                    "h_size": 20,
                    "event": "warning[SC2076]",
                    "message": "Remove quotes from right-hand side of =~ to match as a regex rather than literally.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1009|         for tries in $(seq 1 5); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1010|             run journalctl \"--since=$STARTED_TIME\" --unit=\"$QUADLET_SERVICE_NAME\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1011|->           if [[ \"$output\" =~ \"Started.*\\.service\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1012|                 break",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1013|             fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4c14d5ce5e17ef4377b174108c3ad04ef97005c7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1086,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1084|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1085|       # Create the Quadlet file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1086|->     local quadlet_file=$PODMAN_TMPDIR/basic_$(safename).kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1087|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1088|   [Kube]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "88e10672f273311ebbb07b950301275271b99a00",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1105,
                    "column": 8,
                    "h_size": 42,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1103|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1104|       run_podman exec $pod_name-$container_name /bin/sh -c \"echo hello > /test/test.txt\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1105|->     is $(cat $PODMAN_TMPDIR/$local_path/test.txt) \"hello\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1106|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1107|       service_cleanup $QUADLET_SERVICE_NAME inactive",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b4315020a5c89c3cabc0b00b7b1ffe58141468d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1112,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1110|   # https://github.com/containers/podman/issues/20667",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1111|   @test \"quadlet kube - start error\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1112|->     local port=$(random_free_port)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1113|       # Create the YAMl file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1114|       pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f7c43d9398c7b1a2f5a1eea29537020b0f55a08f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1138,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1136|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1137|       # Create the Quadlet file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1138|->     local quadlet_file=$PODMAN_TMPDIR/start_err_$(safename).kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1139|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1140|   [Kube]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6b4315020a5c89c3cabc0b00b7b1ffe58141468d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1165,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1163|   # https://github.com/containers/podman/issues/25786",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1164|   @test \"quadlet kube - pod without containers\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1165|->     local port=$(random_free_port)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1166|       # Create the YAML file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1167|       pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1e21a1ecae567b2841a8feff17b47037107735e7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1177,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1175|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1176|       # Create the Quadlet file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1177|->     local quadlet_file=$PODMAN_TMPDIR/no_cons_$(safename).kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1178|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1179|   [Kube]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3660eb97d744e8d7555745d2f0eb7f28b60baf0f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1196,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1194|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1195|       local registry=localhost:${PODMAN_LOGIN_REGISTRY_PORT}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1196|->     local image_for_test=$registry/i-$(safename):$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1197|       local authfile=$PODMAN_TMPDIR/authfile.json",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1198|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fa00664aa232a4b9b4c13530a14ee25ee0eab3b6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1199,
                    "column": 11,
                    "h_size": 18,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1197|       local authfile=$PODMAN_TMPDIR/authfile.json",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1198|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1199|->     local quadlet_image_unit=image_test_$(safename).image",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1200|       local quadlet_image_file=$PODMAN_TMPDIR/$quadlet_image_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1201|       cat > $quadlet_image_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4376669fbc59b236c57d794811def618001345fe",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1208,
                    "column": 11,
                    "h_size": 19,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1206|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1207|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1208|->     local quadlet_volume_unit=image_test_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1209|       local quadlet_volume_file=$PODMAN_TMPDIR/$quadlet_volume_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1210|       local volume_name=systemd-$(basename $quadlet_volume_file .volume)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "418cf1879e4e2ae5120ca5ff5137df7d51ac63bd",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1210,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1208|       local quadlet_volume_unit=image_test_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1209|       local quadlet_volume_file=$PODMAN_TMPDIR/$quadlet_volume_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1210|->     local volume_name=systemd-$(basename $quadlet_volume_file .volume)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1211|       cat > $quadlet_volume_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1212|   [Volume]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "63356f1b68e6c4269c6a5d1d6ea4f4197bc65aa0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1217,
                    "column": 11,
                    "h_size": 22,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1215|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1216|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1217|->     local quadlet_container_unit=image_test_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1218|       local quadlet_container_file=$PODMAN_TMPDIR/$quadlet_container_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1219|       cat > $quadlet_container_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "db95096af63e23ed1df3ae4d478c2acf965cebe5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1323,
                    "column": 11,
                    "h_size": 18,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1321|   @test \"quadlet - kube oneshot\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1322|       local quadlet_tmpdir=$PODMAN_TMPDIR/quadlets",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1323|->     local test_random_string=r_$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1324|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1325|       local quadlet_kube_volume_name=test-volume_$test_random_string",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6a8e4ab79924ded30a8c79ea5831598dc7e53f16",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1351,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1349|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1350|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1351|->     local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1352|       local container_name=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1353|       local quadlet_kube_pod_yaml_file=$PODMAN_TMPDIR/pod_$test_random_string.yaml",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d9ba40ad1d5356a0960b3f32f8f16e8f84a04e3d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1352,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1350|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1351|       local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1352|->     local container_name=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1353|       local quadlet_kube_pod_yaml_file=$PODMAN_TMPDIR/pod_$test_random_string.yaml",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1354|       cat > $quadlet_kube_pod_yaml_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "83c22ce6e263a1c5662068816be7553c647d8910",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1428,
                    "column": 11,
                    "h_size": 18,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1426|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1427|   @test \"quadlet - kube down force\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1428|->     local test_random_string=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1429|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1430|       local quadlet_kube_volume_name=test-volume_$test_random_string",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6a8e4ab79924ded30a8c79ea5831598dc7e53f16",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1431,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1429|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1430|       local quadlet_kube_volume_name=test-volume_$test_random_string",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1431|->     local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1432|       local container_name=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1433|       local quadlet_kube_pod_yaml_file=$PODMAN_TMPDIR/pod_$test_random_string.yaml",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d9ba40ad1d5356a0960b3f32f8f16e8f84a04e3d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1432,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1430|       local quadlet_kube_volume_name=test-volume_$test_random_string",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1431|       local pod_name=\"p-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1432|->     local container_name=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1433|       local quadlet_kube_pod_yaml_file=$PODMAN_TMPDIR/pod_$test_random_string.yaml",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1434|       cat > $quadlet_kube_pod_yaml_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "52a8569c859d4979a6a8f2309dbb7dcb19526c34",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1508,
                    "column": 11,
                    "h_size": 14,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1506|       local quadlet_tmpdir=$PODMAN_TMPDIR/quadlets",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1507|       local archive_file=$PODMAN_TMPDIR/archive-file.tar",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1508|->     local image_for_test=localhost/i-$(safename):$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1509|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1510|       local quadlet_image_unit=image_test_$(safename).image",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fa00664aa232a4b9b4c13530a14ee25ee0eab3b6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1510,
                    "column": 11,
                    "h_size": 18,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1508|       local image_for_test=localhost/i-$(safename):$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1509|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1510|->     local quadlet_image_unit=image_test_$(safename).image",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1511|       local quadlet_image_file=$PODMAN_TMPDIR/$quadlet_image_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1512|       cat > $quadlet_image_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4376669fbc59b236c57d794811def618001345fe",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1518,
                    "column": 11,
                    "h_size": 19,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1516|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1517|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1518|->     local quadlet_volume_unit=image_test_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1519|       local quadlet_volume_file=$PODMAN_TMPDIR/$quadlet_volume_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1520|       local volume_name=systemd-$(basename $quadlet_volume_file .volume)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "418cf1879e4e2ae5120ca5ff5137df7d51ac63bd",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1520,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1518|       local quadlet_volume_unit=image_test_$(safename).volume",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1519|       local quadlet_volume_file=$PODMAN_TMPDIR/$quadlet_volume_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1520|->     local volume_name=systemd-$(basename $quadlet_volume_file .volume)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1521|       cat > $quadlet_volume_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1522|   [Volume]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "63356f1b68e6c4269c6a5d1d6ea4f4197bc65aa0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1527,
                    "column": 11,
                    "h_size": 22,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1525|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1526|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1527|->     local quadlet_container_unit=image_test_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1528|       local quadlet_container_file=$PODMAN_TMPDIR/$quadlet_container_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1529|       cat > $quadlet_container_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b0ee610cd0a04d3431db0f9f6672fbef06160d02",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1600,
                    "column": 11,
                    "h_size": 13,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1598|       local quadlet_tmpdir=$PODMAN_TMPDIR/quadlets",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1599|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1600|->     local test_pod_name=pod_test_$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1601|       local quadlet_pod_unit=$test_pod_name.pod",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1602|       local quadlet_pod_file=$PODMAN_TMPDIR/$quadlet_pod_unit",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a9c377bb1ee6300a8cc644db9becaa3b2a59ae49",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1608,
                    "column": 11,
                    "h_size": 22,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1606|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1607|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1608|->     local quadlet_container_unit=pod_test_$(safename).container",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1609|       local quadlet_container_file=$PODMAN_TMPDIR/$quadlet_container_unit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1610|       cat > $quadlet_container_file <<EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "93870f8713470d11ea23659dfffc12442f9823a4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1649,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "tries appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1647|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1648|       # It might take a few seconds to go inactive, esp. under heavy load",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1649|->     for tries in $(seq 1 5); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1650|           run systemctl show --property=ActiveState \"$container_service\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1651|           if [[ \"$output\" = \"ActiveState=inactive\" ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "dc86bb4de939ea37eb43fe5580e1c12a8c74b5f1",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1672,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1670|       # FIXME: how to make this parallel-safe? Can we?",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1671|       local untagged_image=quay.io/libpod/busybox",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1672|->     local built_image=\"built-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1673|       local yaml_dir=$quadlet_tmpdir/$built_image",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1674|       local build_dir=$yaml_dir/$built_image",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d76085c9527d8b932289eb67c25776f5964fcd06",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1707,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1705|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1706|       # Create the Quadlet file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1707|->     local quadlet_file=$quadlet_tmpdir/build_$(safename).kube",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1708|       cat > $quadlet_file <<EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1709|   [Kube]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8ab1ccaed678131950baa42adb19225f2070e104",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1734,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1732|       local quadlet_tmpdir=\"${PODMAN_TMPDIR}/dropins\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1733|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1734|->     local quadlet_file=\"truncated-$(safename).container\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1735|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1736|       local -A dropin_dirs=(",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e884577efa7fa66196039381b66a073871bbd1cb",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1797,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1795|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1796|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1797|->     local image_tag=quay.io/i-$(safename):$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1798|       local quadlet_file=$PODMAN_TMPDIR/pull_$(safename).build",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1799|       cat >$quadlet_file << EOF",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ad211dcf2f87f9074e4cac28f2cff4b10295d1e0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/252-quadlet.bats",
                    "line": 1798,
                    "column": 11,
                    "h_size": 12,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1796|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1797|       local image_tag=quay.io/i-$(safename):$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1798|->     local quadlet_file=$PODMAN_TMPDIR/pull_$(safename).build",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1799|       cat >$quadlet_file << EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": " 1800|   [Build]",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0f05a5480f9fcc4eafef529badafafa7240dad32",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for automatically update images for containerized services",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 252,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9a0345199e4720af48d15271a30abc080986935c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 96,
                    "column": 6,
                    "h_size": 12,
                    "event": "warning[SC2164]",
                    "message": "Use 'cd ... || exit' or 'cd ... || return' in case cd fails.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   94|       run_podman create $extraArgs --name $cname $label $target_img $command",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   95|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   96|->     (cd $UNIT_DIR; run_podman generate systemd --new --files --name $requires $cname)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   97|       echo \"container-$cname\" >> $SNAME_FILE",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   98|       run_podman rm -t 0 -f $cname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 153,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "888a6f4d5bafb57f790837a567d899338d159704",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 143,
                    "column": 28,
                    "h_size": 8,
                    "event": "warning[SC2053]",
                    "message": "Quote the right-hand side of != in [[ ]] to prevent glob matching.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  141|                   die \"podman inspect $cname failed unexpectedly\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  142|               fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  143|->         elif [[ $output != $old_iid ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  144|               return",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  145|           fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 456,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "eb01641cae256f21e04830ff111d6c5d5cd025cc",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 323,
                    "column": 5,
                    "h_size": 5,
                    "event": "warning[SC2209]",
                    "message": "Use var=$(command) to assign output (or quote to assign string).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  321|   RUN chmod +x /runme",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  322|   EOF",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  323|->     image=test",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  324|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  325|       # Generate a healthy image that will run correctly.",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b491a03a943d5a644c4aba97db828a03682337bd",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 359,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  357|       local -A will_update=([image]=1 [registry]=1 [local]=1)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  358|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  359|->     local fakevalue=fake_$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  360|       for auto_update in image registry \"\" disabled \"''\" $fakevalue local",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  361|       do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "37c352f47916bd7732d5916b0fb8d0270c79e8b2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 360,
                    "column": 52,
                    "h_size": 2,
                    "event": "warning[SC2089]",
                    "message": "Quotes/backslashes will be treated literally. Use an array.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  358|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  359|       local fakevalue=fake_$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  360|->     for auto_update in image registry \"\" disabled \"''\" $fakevalue local",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  361|       do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  362|           local img_base=\"alpine\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "517370b6ce3b09ba260a45424c77a9fd3a50681e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 368,
                    "column": 36,
                    "h_size": 12,
                    "event": "warning[SC2090]",
                    "message": "Quotes/backslashes in this variable will not be respected.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  366|               img_base=\"localtest\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  367|           fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  368|->         generate_service $img_base $auto_update",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  369|           cnames+=($cname)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  370|           if [[ $auto_update == \"local\" ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b30f8c4e92de2fbe55205959d950ea1894fbf642",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 369,
                    "column": 18,
                    "h_size": 6,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  367|           fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  368|           generate_service $img_base $auto_update",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  369|->         cnames+=($cname)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  370|           if [[ $auto_update == \"local\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  371|               local_cname=$cname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "238e38bda7b81f719b896aa4ffc05a24e6556d23",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 390,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  388|       is \"$update_log\" \".*Error: invalid auto-update policy.*\" \"invalid policy setup\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  389|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  390|->     local n_updated=$(grep -c 'Trying to pull' <<<\"$update_log\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  391|       is \"$n_updated\" \"2\" \"Number of images updated from registry.\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  392|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1699e8db54d1a7b5baf033ec91002d71f48c5fa5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 436,
                    "column": 25,
                    "h_size": 13,
                    "event": "warning[SC2154]",
                    "message": "http_proxy is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  434|   Type=oneshot",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  435|   ExecStart=$PODMAN auto-update",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  436|-> Environment=\"http_proxy=${http_proxy}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  437|   Environment=\"HTTP_PROXY=${HTTP_PROXY}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  438|   Environment=\"https_proxy=${https_proxy}\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a60bb099da39b6a7dc2237e1be0de2b633c1177c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 438,
                    "column": 26,
                    "h_size": 14,
                    "event": "warning[SC2154]",
                    "message": "https_proxy is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  436|   Environment=\"http_proxy=${http_proxy}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  437|   Environment=\"HTTP_PROXY=${HTTP_PROXY}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  438|-> Environment=\"https_proxy=${https_proxy}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  439|   Environment=\"HTTPS_PROXY=${HTTPS_PROXY}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  440|   Environment=\"no_proxy=${no_proxy}\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1ee56eb0d0011a6772a3321508f5db766c84e64f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 440,
                    "column": 23,
                    "h_size": 11,
                    "event": "warning[SC2154]",
                    "message": "no_proxy is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  438|   Environment=\"https_proxy=${https_proxy}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  439|   Environment=\"HTTPS_PROXY=${HTTPS_PROXY}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  440|-> Environment=\"no_proxy=${no_proxy}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  441|   Environment=\"NO_PROXY=${NO_PROXY}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  442|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "686a9c7f014ab6fdddf52368bbc71b235d275851",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 566,
                    "column": 23,
                    "h_size": 14,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  564|       # Clean up",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  565|       systemctl stop $service_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  566|->     run_podman rmi -f $(pause_image) $local_image $newID $oldID",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  567|       run_podman network rm podman-default-kube-network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  568|       rm -f $UNIT_DIR/$unit_name",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 457,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "228005ff2fbfa420922b47caeba0681845479b88",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 568,
                    "column": 21,
                    "h_size": 10,
                    "event": "warning[SC2154]",
                    "message": "unit_name is referenced but not assigned.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  566|       run_podman rmi -f $(pause_image) $local_image $newID $oldID",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  567|       run_podman network rm podman-default-kube-network",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  568|->     rm -f $UNIT_DIR/$unit_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  569|   }",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  570|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e9ba811fcb992f8e1320f4f7f2fbddaa28e07226",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/255-auto-update.bats",
                    "line": 633,
                    "column": 33,
                    "h_size": 14,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  631|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  632|       run_podman pod rm -f $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  633|->     run_podman rmi $local_image $(pause_image)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  634|       rm -f $podunit $ctrunit",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  635|       systemctl daemon-reload",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "efee2d0b61daae5baabd552b5bd7b7b483667608",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for systemd sdnotify",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "dffc7b1140af686f1010d6a1893faac296385072",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 58,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "try appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   56|       # Wait for socat to create the socket file. This _should_ be",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   57|       # instantaneous, but can take a few seconds under high load",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   58|->     for try in $(seq 1 10); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   59|           if [[ -e \"$NOTIFY_SOCKET\" ]]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   60|               return",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4a7b48bc91501b572ae60813b839a127a6c10b4b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 87,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   85|   # Check that MAINPID=xxxxx points to a running conmon process",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   86|   function _assert_mainpid_is_conmon() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   87|->     local mainpid=$(expr \"$1\" : \".*MAINPID=\\([0-9]\\+\\)\")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   88|       test -n \"$mainpid\" || die \"Could not parse '$1' as 'MAINPID=nnnn'\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   89|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9e62bb96496e06f4f8adc8573ac3b2830731ab5c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 93,
                    "column": 11,
                    "h_size": 11,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   91|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   92|       # e.g. /proc/12345/exe -> /usr/bin/conmon",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   93|->     local mainpid_bin=$(readlink /proc/$mainpid/exe)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   94|       is \"$mainpid_bin\" \".*/conmon\" \"sdnotify MAINPID=$mainpid is conmon process\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   95|   }",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b5ab051f1b14acd8675514d9c4f4d953b1b1df15",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 390,
                    "column": 5,
                    "h_size": 3,
                    "event": "warning[SC2034]",
                    "message": "i appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  388|       # Wait for both containers to be running",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  389|       containers_running=",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  390|->     for i in $(seq 1 20); do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  391|           run_podman \"?\" container wait $container_a $container_b --condition=\"running\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  392|           if [[ $status == 0 ]]; then",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "be4f045f06a174cc2bb61357510b9ccd25664c43",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 458,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  456|       local cmd2=$3",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  457|       local sdnotify_policy=$4",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  458|->     local podname=p-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  459|       echo \"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  460|   apiVersion: v1",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 149,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "88073f117fb5a286c68e8d6a68c40a180998696e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 467,
                    "column": 30,
                    "h_size": 16,
                    "event": "warning[SC2027]",
                    "message": "The surrounding quotes actually unquote this. Remove or escape them.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  465|     name: $podname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  466|     annotations:",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  467|->     io.containers.sdnotify: \"$sdnotify_policy\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  468|   spec:",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|     restartPolicy: Never",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7833c7422d80bdd3585e5eb08aebeaf6b330d50a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 553,
                    "column": 12,
                    "h_size": 13,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  551|       start_registry",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  552|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  553|->     export NOTIFY_SOCKET=$PODMAN_TMPDIR/notify-$(safename).sock",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  554|       _start_socat",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  555|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4bf0ca3c3604c37f67e16c5c68a835f03dbe892c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/260-sdnotify.bats",
                    "line": 585,
                    "column": 5,
                    "h_size": 7,
                    "event": "warning[SC2034]",
                    "message": "envfile appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  583|       export NOTIFY_SOCKET=$PODMAN_TMPDIR/notify.sock",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  584|       podman_socket=\"unix://$PODMAN_TMPDIR/podman.sock\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  585|->     envfile=$PODMAN_TMPDIR/envfile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  586|       _start_socat",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  587|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0e46c1656df972ee38ab6608c87bb89a56144732",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/270-socket-activation.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests podman system service under systemd socket activation",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9f910e88ea11f2d221abd0ec20a5d06fdcde740a",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/270-socket-activation.bats",
                    "line": 67,
                    "column": 21,
                    "h_size": 20,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   65|           local pause_pid_file=\"$XDG_RUNTIME_DIR/libpod/tmp/pause.pid\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   66|           if [ -f $pause_pid_file ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   67|->             kill -9 $(< $pause_pid_file) 2> /dev/null",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   68|               rm -f $pause_pid_file",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   69|           fi",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2b0b6fab1879e3240979a73bddeaeed400730704",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/270-socket-activation.bats",
                    "line": 114,
                    "column": 13,
                    "h_size": 20,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  112|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  113|       echo \"kill -9 $(< $pause_pid_file) [pause process]\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  114|->     kill -9 $(< $pause_pid_file)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  115|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  116|       run curl -s --max-time 3 --unix-socket $SERVICE_SOCK_ADDR $_PING",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d89063c5ea21ca4703ed9da882f3ca21545d7109",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/271-tcp-cors-server.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests podman system service CORS enabled",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d76a7267477bcf655c1a5e6c6e2d8e3bd35e8aa8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/271-tcp-cors-server.bats",
                    "line": 13,
                    "column": 1,
                    "h_size": 12,
                    "event": "warning[SC2034]",
                    "message": "SERVICE_FILE appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|   SERVICE_TCP_HOST=\"127.0.0.1\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|-> SERVICE_FILE=\"$UNIT_DIR/$SERVICE_NAME.service\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|   SOCKET_FILE=\"$UNIT_DIR/$SERVICE_NAME.socket\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f02f25143770920bba6f17ee681b884ca1e2aa77",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/271-tcp-cors-server.bats",
                    "line": 14,
                    "column": 1,
                    "h_size": 11,
                    "event": "warning[SC2034]",
                    "message": "SOCKET_FILE appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|   SERVICE_FILE=\"$UNIT_DIR/$SERVICE_NAME.service\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|-> SOCKET_FILE=\"$UNIT_DIR/$SERVICE_NAME.socket\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   16|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "6148de1819215516593bdd8d9372d7ba50a344e6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman system connection",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "17d3b87e0253b52ad1c6b71fb7c8753a71d82b09",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 64,
                    "column": 11,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   62|       run_podman system connection ls",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   63|       is \"$output\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   64|->        \".*$c1[ ]\\+tcp://localhost:12345[ ]\\+true[ ]\\+true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   65|   $c2[ ]\\+tcp://localhost:54321[ ]\\+false[ ]\\+true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   66|          \"system connection ls\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b5ba97e021a7220ccafcd3de6cc7f6655946b2c6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 65,
                    "column": 1,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   63|       is \"$output\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   64|          \".*$c1[ ]\\+tcp://localhost:12345[ ]\\+true[ ]\\+true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   65|-> $c2[ ]\\+tcp://localhost:54321[ ]\\+false[ ]\\+true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   66|          \"system connection ls\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   67|       run_podman system connection ls -q",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "acdc3bb33551639aefe4180a50f6bf0e47960a8e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 68,
                    "column": 16,
                    "h_size": 18,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   66|          \"system connection ls\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   67|       run_podman system connection ls -q",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   68|->     is \"$(echo $(sort <<<$output))\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   69|          \"$c1 $c2\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   70|          \"system connection ls -q should show two names\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "acdc3bb33551639aefe4180a50f6bf0e47960a8e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 72,
                    "column": 16,
                    "h_size": 18,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   70|          \"system connection ls -q should show two names\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   71|       run_podman context ls -q",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   72|->     is \"$(echo $(sort <<<$output))\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   73|          \"$c1 $c2\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   74|          \"context ls -q should show two names\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d2f40a943981a8bf02525b6f109694ad19128c80",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 78,
                    "column": 11,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   76|       run_podman system connection ls",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   77|       is \"$output\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   78|->        \".*$c1[ ]\\+tcp://localhost:12345[ ]\\+false[ ]\\+true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   79|   $c2[ ]\\+tcp://localhost:54321[ ]\\+true[ ]\\+true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   80|          \"system connection ls\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "bbf52b0c571baa58b99bc19e0cd5e002b7dc66be",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 79,
                    "column": 1,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   77|       is \"$output\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   78|          \".*$c1[ ]\\+tcp://localhost:12345[ ]\\+false[ ]\\+true",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   79|-> $c2[ ]\\+tcp://localhost:54321[ ]\\+true[ ]\\+true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   80|          \"system connection ls\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   81|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "15bacf52450c2edd6b60984c96cfeab346a9b806",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 85,
                    "column": 21,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   83|       run_podman system connection rm $c2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   84|       run_podman context ls",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   85|->     is \"$output\" \".*$c1[ ]\\+tcp://localhost:12345[ ]\\+false[ ]\\+true\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   86|          \"system connection ls (after removing default connection)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   87|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 156,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "596b341516c9ddbf67307c4c0afa8e29564e3673",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/272-system-connection.bats",
                    "line": 111,
                    "column": 25,
                    "h_size": 41,
                    "event": "warning[SC2046]",
                    "message": "Quote this to prevent word splitting.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  109|       # converts \"podman-remote --opts\" to just \"podman\", which is what",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  110|       # we need for the server.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  111|->     ${PODMAN%%-remote*} $(podman_isolation_opts ${PODMAN_TMPDIR}) \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  112|                           system service -t 99 tcp://localhost:$_SERVICE_PORT &",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  113|       _SERVICE_PID=$!",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "da81f32e5b5cef8a6201687920c9d20e48e5de59",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests for podman update",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8cfc47c53eb56c0bef24de7141792ba72be2a718",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 173,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  171|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  172|   @test \"podman update - test all HealthCheck flags\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  173|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  174|       local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  175|       local TMP_DIR_HEALTHCHECK=\"$PODMAN_TMPDIR/healthcheck\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "75cfbd4fd45b22df69ae3a66e3d0a6b71c3d655b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 174,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  172|   @test \"podman update - test all HealthCheck flags\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  173|       local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  174|->     local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  175|       local TMP_DIR_HEALTHCHECK=\"$PODMAN_TMPDIR/healthcheck\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  176|       mkdir $TMP_DIR_HEALTHCHECK",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8cfc47c53eb56c0bef24de7141792ba72be2a718",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 232,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  230|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  231|   @test \"podman update - test HealthCheck flags without HealthCheck commands\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  232|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  233|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  234|       # flag-name=value",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "75cfbd4fd45b22df69ae3a66e3d0a6b71c3d655b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 261,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  259|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  260|   @test \"podman update - --no-healthcheck\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  261|->     local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  262|       local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  263|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8cfc47c53eb56c0bef24de7141792ba72be2a718",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 262,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  260|   @test \"podman update - --no-healthcheck\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  261|       local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  262|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  263|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  264|       run_podman run -d --name $ctrname                    \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ebca75cf9d3896f88b576be49cc8c5f6395c0134",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 272,
                    "column": 42,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  270|       run_podman update $ctrname --no-healthcheck",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  271|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  272|->     run_podman inspect $ctrname --format {{.Config.Healthcheck.Test}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ebca75cf9d3896f88b576be49cc8c5f6395c0134",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 272,
                    "column": 43,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  270|       run_podman update $ctrname --no-healthcheck",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  271|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  272|->     run_podman inspect $ctrname --format {{.Config.Healthcheck.Test}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0fd09859d8fea2867041a9d68ad642d26f834d91",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 272,
                    "column": 68,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  270|       run_podman update $ctrname --no-healthcheck",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  271|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  272|->     run_podman inspect $ctrname --format {{.Config.Healthcheck.Test}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0fd09859d8fea2867041a9d68ad642d26f834d91",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 272,
                    "column": 69,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  270|       run_podman update $ctrname --no-healthcheck",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  271|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  272|->     run_podman inspect $ctrname --format {{.Config.Healthcheck.Test}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d085e0b483bc7c51f6ec4aeba2b5b45bb10da0be",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 275,
                    "column": 42,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  275|->     run_podman inspect $ctrname --format {{.Config.StartupHealthCheck}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  276|       assert \"$output\" == \"<nil>\" \"startup HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  277|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d085e0b483bc7c51f6ec4aeba2b5b45bb10da0be",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 275,
                    "column": 43,
                    "event": "warning[SC1083]",
                    "message": "This { is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  275|->     run_podman inspect $ctrname --format {{.Config.StartupHealthCheck}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  276|       assert \"$output\" == \"<nil>\" \"startup HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  277|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9e352c05865d8537dbe020ae0016a3885095141d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 275,
                    "column": 70,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  275|->     run_podman inspect $ctrname --format {{.Config.StartupHealthCheck}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  276|       assert \"$output\" == \"<nil>\" \"startup HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  277|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "9e352c05865d8537dbe020ae0016a3885095141d",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 275,
                    "column": 71,
                    "event": "warning[SC1083]",
                    "message": "This } is literal. Check expression (missing ;/\\n?) or quote it.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  273|       assert \"$output\" == \"[NONE]\" \"HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  274|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  275|->     run_podman inspect $ctrname --format {{.Config.StartupHealthCheck}}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  276|       assert \"$output\" == \"<nil>\" \"startup HealthCheck command is disabled\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  277|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8cfc47c53eb56c0bef24de7141792ba72be2a718",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 285,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  283|       local TMP_DIR_HEALTHCHECK=\"$PODMAN_TMPDIR/healthcheck\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  284|       mkdir $TMP_DIR_HEALTHCHECK",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  285|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|       local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "75cfbd4fd45b22df69ae3a66e3d0a6b71c3d655b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 286,
                    "column": 11,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  284|       mkdir $TMP_DIR_HEALTHCHECK",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  285|       local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  286|->     local msg=\"healthmsg-$(random_string)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  287|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  288|       run_podman run -d --name $ctrname     \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8cfc47c53eb56c0bef24de7141792ba72be2a718",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/280-update.bats",
                    "line": 315,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  313|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  314|   @test \"podman update - resources on update are not changed unless requested\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  315|->     local ctrname=\"c-h-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  316|       run_podman run -d --name $ctrname \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  317|                   --pids-limit 1024     \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "f8284b953338b4b5fffc35bfeebb1e7fbf1ec576",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/300-cli-parsing.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Various command-line parsing regression tests that don't fit in elsewhere",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "43f9df6eb2c3903e1bb52e45d2797191b5fa580e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/300-cli-parsing.bats",
                    "line": 179,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  177|   @test \"podman run --env with glob\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  178|       # Set a bunch of different envariables with a common prefix",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  179|->     local prefix=\"env$(random_string 10)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  180|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  181|       # prefix by itself",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "70fd3c7156c0a57ef33cd370956487a856691968",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/320-system-df.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # tests for podman system df",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2bb1f070ab52e8d977fe46ca3c06137d996b2545",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/320-system-df.bats",
                    "line": 166,
                    "column": 11,
                    "h_size": 2,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  164|   # https://github.com/containers/podman/issues/24452",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  165|   @test \"podman system df - Reclaimable is not negative\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|->     local c1=\"c1-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|       local c2=\"c2-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|       for t in \"$c1\" \"$c2\"; do",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4ba5271d9b8e1f936e3e51d2faf47edca17779ee",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/320-system-df.bats",
                    "line": 167,
                    "column": 11,
                    "h_size": 2,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  165|   @test \"podman system df - Reclaimable is not negative\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|       local c1=\"c1-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|->     local c2=\"c2-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|       for t in \"$c1\" \"$c2\"; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  169|           dir=\"${PODMAN_TMPDIR}${t}\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b39ecbe1bedc3822c7515963588dc7989fba73bb",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/330-corrupt-images.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # All tests in here perform nasty manipulations on image storage.",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "c005a296e24706653e446d8908738f1e37df3f96",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/330-corrupt-images.bats",
                    "line": 13,
                    "column": 12,
                    "h_size": 27,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   11|   # Create a scratch directory; this is what we'll use for image store and cache",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   12|   if [ -z \"${PODMAN_CORRUPT_TEST_WORKDIR}\" ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   13|->     export PODMAN_CORRUPT_TEST_WORKDIR=$(mktemp -d --tmpdir=${BATS_TMPDIR:-${TMPDIR:-/tmp}} podman_corrupt_test.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   14|   fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   15|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 569,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7561b8cb6cb4f7f4e4471ac0e3348bfd05487ef7",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/330-corrupt-images.bats",
                    "line": 85,
                    "column": 24,
                    "h_size": 2,
                    "event": "warning[SC2048]",
                    "message": "Use \"$@\" (with quotes) to prevent whitespace problems.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   83|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   84|           # Run the requested command. Confirm it succeeds, with suitable warnings.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   85|->         run_podman 0+w $*",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   86|           # There are three different variations on the warnings, allow each...",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   87|           allow_warnings \"Failed to determine parent of image: .*, ignoring the error\" \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1ac8766a12d599d06be09624fa227c86694173b5",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/331-system-check.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Creates errors that should be caught by `system check`, and verifies",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2a781abc23a817ed753726320167594ca82174ed",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/331-system-check.bats",
                    "line": 203,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  201|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  202|   function make_layer_blob() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  203|->     local tmpdir=$(mktemp -d --tmpdir=${PODMAN_TMPDIR} make_layer_blob.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  204|       local blobfile",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  205|       local seqargs",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "03fa140a6f7ed5e74c9084a8d584184f30099daa",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/331-system-check.bats",
                    "line": 220,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  218|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  219|   function testing_make_image_metadata_for_layer_blobs() {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  220|->     local tmpdir=$(mktemp -d --tmpdir=${PODMAN_TMPDIR} make_image_metadata.XXXXXX)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  221|       local imageID=$1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  222|       shift",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b0689403adc7837c010577af26c32de4805d325e",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/331-system-check.bats",
                    "line": 227,
                    "column": 15,
                    "h_size": 3,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  225|       local comma=",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  226|       for blob in \"$@\" ; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|->         local sum=$(sha256sum $blob)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  228|           sum=${sum%% *}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  229|           local size=$(wc -c $blob)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a5dbe41c7cde264aa3ed08b0ec775eb4b9d6cd18",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/331-system-check.bats",
                    "line": 229,
                    "column": 15,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|           local sum=$(sha256sum $blob)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  228|           sum=${sum%% *}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  229|->         local size=$(wc -c $blob)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  230|           size=${size%% *}",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  231|           echo $comma '\"sha256:'$sum'\"' >> $tmpdir/config.json",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ca3c399d7bfc3acda8ce2ae433ca06ee3f138657",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/400-unprivileged-access.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Tests #2730 - regular users are not able to read/write container storage",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 563,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7cc7deaf0a9d8f7e048c233343185cf437f4eb6c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/400-unprivileged-access.bats",
                    "line": 21,
                    "column": 5,
                    "h_size": 10,
                    "event": "warning[SC2034]",
                    "message": "mount_path appears unused. Verify use (or export if used externally).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   19|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   20|       run_podman mount c_mount",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   21|->     mount_path=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   22|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   23|       # Do all the work from within a test script. Since we'll be invoking it",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 140,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "40c8e25ce04a7a2fcb2b9240423911adf84b92e0",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/400-unprivileged-access.bats",
                    "line": 135,
                    "column": 22,
                    "h_size": 3,
                    "event": "warning[SC2206]",
                    "message": "Quote to prevent word splitting/globbing, or split robustly with mapfile or read -a.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  133|       for mp in \"${mps[@]}\"; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  134|           if [ -e $mp ]; then",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  135|->             subset+=($mp)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  136|           fi",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  137|       done",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "b3bcefcc0dbf834cbae638264c7bc8de4db8bd16",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/410-selinux.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # 410-selinux - podman selinux tests",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8fd608b24c7e5e4b739adf1ec9bf34f06f8b63a2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/410-selinux.bats",
                    "line": 201,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  199|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  200|       # unique pod name helps when tracking down failure in journal",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  201|->     local podname=p-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  202|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  203|       # We don't need a fullblown pause container; avoid pulling the k8s one",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8fd608b24c7e5e4b739adf1ec9bf34f06f8b63a2",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/410-selinux.bats",
                    "line": 229,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  227|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  228|       # unique pod name helps when tracking down failure in journal",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  229|->     local podname=p-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  230|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  231|       # We don't need a fullblown pause container; avoid pulling the k8s one",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "0763fd9c5bd699029b8b84231cf66e68685d8843",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/420-cgroups.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # cgroups-related tests",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "ba7b2f7ef45559b32d0cd4f05cc059b732b9512c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 1,
                    "column": 1,
                    "h_size": 34,
                    "event": "error[SC2096]",
                    "message": "On most OS, shebangs can only specify a single parameter.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    1|-> #!/usr/bin/env bats   -*- bats -*-",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    2|   #",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "    3|   # Test podman local networking",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "8a9cdb9ba977c4ae23c51c0ecfe1cff25042e389",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 24,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   22|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   23|       # check deterministic list order",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   24|->     local net1=net-a-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   25|       local net2=net-b-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|       local net3=net-c-$(safename)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3b7efa9d2ef0700559eb4493f6e571b5166fc506",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 25,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   23|       # check deterministic list order",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   24|       local net1=net-a-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   25|->     local net2=net-b-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|       local net3=net-c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   27|       run_podman network create $net1",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "886dd95d715c1bfbcf0c52147081496386da6c3c",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 26,
                    "column": 11,
                    "h_size": 4,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   24|       local net1=net-a-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   25|       local net2=net-b-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   26|->     local net3=net-c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   27|       run_podman network create $net1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "   28|       run_podman network create $net2",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a05a94dc6fb16fa653c6f4b85885880702fbf6f4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 166,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  164|   # bats test_tags=ci:parallel",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  165|   @test \"podman pod manages /etc/hosts correctly\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|->     local pod_name=pod-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|       local infra_name=infra-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|       local con1_name=con1-$(safename)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "fef3862fec269281fc427c0538ed247aa033a95b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 167,
                    "column": 11,
                    "h_size": 10,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  165|   @test \"podman pod manages /etc/hosts correctly\" {",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|       local pod_name=pod-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|->     local infra_name=infra-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|       local con1_name=con1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  169|       local con2_name=con2-$(safename)",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "bbf49abec0ab3077cc44482772ca2f413b171bbf",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 168,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  166|       local pod_name=pod-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|       local infra_name=infra-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|->     local con1_name=con1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  169|       local con2_name=con2-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  170|       run_podman pod create --name $pod_name  --infra-name $infra_name",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "3faf640371f18bee2d15dea412ef1230a82145ad",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 169,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  167|       local infra_name=infra-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  168|       local con1_name=con1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  169|->     local con2_name=con2-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  170|       run_podman pod create --name $pod_name  --infra-name $infra_name",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  171|       pid=\"$output\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "e6ebad372b0d10f420805856617e9b499f9cdd0f",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 206,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  204|       CIDR=\"$(random_rfc1918_subnet)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  205|       IP=$(hostname -I | cut -f 1 -d \" \")",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  206|->     local conname=con-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  207|       run_podman run --rm --network slirp4netns:cidr=\"${CIDR}.0/24\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  208|                   --name $conname --hostname $conname $IMAGE cat /etc/hosts",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a50d00bbc55911045f2004e1004529ea968039c9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 256,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  254|       myport=$(random_free_port)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  255|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  256|->     local mynetname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  257|       local mysubnet=$(random_rfc1918_subnet)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  258|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "869308d129e8dc4ae4f7d2aa012d00afdfbbbfe3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 257,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  255|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  256|       local mynetname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  257|->     local mysubnet=$(random_rfc1918_subnet)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  258|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  259|       run_podman network create --subnet \"${mysubnet}.0/24\" $mynetname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "d05863f1b3f38e6305684ef3a478ad7de25076d6",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 270,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  268|          \"sdfsdf\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  269|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  270|->     local cname=\"c-$(safename)\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  271|       run_podman run -d --network $mynetname --name $cname -p 127.0.0.1:$myport:$myport \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  272|                  $IMAGE nc -l -n -v -p $myport",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "dfaa803cc49000e216fe2dee5e6cd03f84c67bcf",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 329,
                    "column": 11,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  327|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  328|       # Bind-mount this file with a different name to a container running httpd",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  329|->     local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  330|       run_podman run -d --name $cname -p \"$HOST_PORT:80\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  331|               --network $netname \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "a50d00bbc55911045f2004e1004529ea968039c9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 429,
                    "column": 11,
                    "h_size": 9,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  427|       is_rootless || skip \"only meaningful for rootless\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  428|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  429|->     local mynetname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  430|       run_podman --noout network create $mynetname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  431|       is \"$output\" \"\" \"output should be empty\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "869308d129e8dc4ae4f7d2aa012d00afdfbbbfe3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 470,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  468|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|       # ipv4 cni",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  470|->     local mysubnet=$(random_rfc1918_subnet)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|       local netname=testnet1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|   ",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2e05af650744782a999a7baa09915070d6853e3b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 471,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  469|       # ipv4 cni",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  470|       local mysubnet=$(random_rfc1918_subnet)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  471|->     local netname=testnet1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  472|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  473|       run_podman network create --subnet $mysubnet.0/24 $netname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2e05af650744782a999a7baa09915070d6853e3b",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 505,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  503|       echo $random_1 > $INDEX1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  504|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  505|->     local netname=testnet1-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  506|       run_podman network create $netname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  507|       is \"$output\" \"$netname\" \"output of 'network create'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "53def316ea57fa66a2f3a9f216666d79f5c1fbaa",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 509,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  507|       is \"$output\" \"$netname\" \"output of 'network create'\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  508|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  509|->     local netname2=testnet2-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  510|       run_podman network create $netname2",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  511|       is \"$output\" \"$netname2\" \"output of 'network create'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7e02222cae93fe6b8b4639d21b1d4f31a41811e4",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 518,
                    "column": 11,
                    "h_size": 8,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  516|       background_cid=$output",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  517|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  518|->     local hostname=host-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  519|       # Run a httpd container on first network with exposed port",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  520|       run_podman run -d -p \"$HOST_PORT:80\" \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "360e5de0ae110685264300692ab1f9e5223e45fd",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 629,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  627|       echo $random_1 > $INDEX1",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  628|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  629|->     local netname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  630|       run_podman network create $netname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  631|       is \"$output\" \"$netname\" \"output of 'network create'\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "dfaa803cc49000e216fe2dee5e6cd03f84c67bcf",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 639,
                    "column": 15,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  637|       for network in \"${networks[@]}\"; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  638|           # Start container with the restart always policy",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  639|->         local cname=c-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  640|           run_podman run -d --name $cname -p \"$HOST_PORT:80\" \\",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  641|                   --restart always \\",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "360e5de0ae110685264300692ab1f9e5223e45fd",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 734,
                    "column": 11,
                    "h_size": 7,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  732|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  733|       # create network with dns",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  734|->     local netname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  735|       local subnet=$(random_rfc1918_subnet)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  736|       run_podman network create --subnet \"$subnet.0/24\"  $netname",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "4195241bf3774ba0934c9b47b33c1f42db0a8738",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 735,
                    "column": 11,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  733|       # create network with dns",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  734|       local netname=testnet-$(safename)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  735|->     local subnet=$(random_rfc1918_subnet)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  736|       run_podman network create --subnet \"$subnet.0/24\"  $netname",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  737|       # custom server overwrites the network dns server",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "7585e147e4db1b5cc4a7d0a8a803e2782855cbe8",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 789,
                    "column": 15,
                    "h_size": 5,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  787|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  788|       for netmode in \"${netmodes[@]}\"; do",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  789|->         local range=$(random_free_port_range 3)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  790|           # die() inside $(...) does not actually stop us.",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  791|           assert \"$range\" != \"\" \"Could not find free port range\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 571,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "68a5552fa9d48ab14dce4dc8e9ef20a0ebe7a7cb",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 795,
                    "column": 15,
                    "h_size": 6,
                    "event": "warning[SC2155]",
                    "message": "Declare and assign separately to avoid masking return values.",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  793|           local port=\"${range%-*}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  794|           local end_port=\"${range#*-}\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  795|->         local random=$(random_string)",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  796|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  797|           run_podman run --network $netmode -p \"$range:$range\" -d $IMAGE sleep inf",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "1359533caf001b5d7af8d39b15e7ea4b479ae5b9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 855,
                    "column": 21,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  853|   ",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  854|       CONTAINERS_CONF_OVERRIDE=$containersconf run_podman run --rm --add-host $name3:$ip3 $IMAGE cat /etc/hosts",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  855|->     is \"$output\" \".*$ip3[[:blank:]]$name3.*\" \"--add-host entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  856|       is \"$output\" \".*$ip1[[:blank:]]$name1.*\" \"first base entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  857|       is \"$output\" \".*$ip2[[:blank:]]$name2.*\" \"second base entry in /etc/host\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "2c5cda6b2431dc705aff6c0c4ea4a1e2e32dd8b9",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 856,
                    "column": 21,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  854|       CONTAINERS_CONF_OVERRIDE=$containersconf run_podman run --rm --add-host $name3:$ip3 $IMAGE cat /etc/hosts",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  855|       is \"$output\" \".*$ip3[[:blank:]]$name3.*\" \"--add-host entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  856|->     is \"$output\" \".*$ip1[[:blank:]]$name1.*\" \"first base entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  857|       is \"$output\" \".*$ip2[[:blank:]]$name2.*\" \"second base entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  858|       is \"$output\" \".*127.0.0.1[[:blank:]]localhost.*\" \"ipv4 localhost entry added\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "c6203d792bee5ce16112ad758cdce5f3b0e0bc40",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 857,
                    "column": 21,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  855|       is \"$output\" \".*$ip3[[:blank:]]$name3.*\" \"--add-host entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  856|       is \"$output\" \".*$ip1[[:blank:]]$name1.*\" \"first base entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  857|->     is \"$output\" \".*$ip2[[:blank:]]$name2.*\" \"second base entry in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  858|       is \"$output\" \".*127.0.0.1[[:blank:]]localhost.*\" \"ipv4 localhost entry added\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  859|       is \"$output\" \".*::1[[:blank:]]localhost.*\" \"ipv6 localhost entry added\"",
                    "verbosity_level": 1
                }
            ]
        },
        {
            "checker": "SHELLCHECK_WARNING",
            "cwe": 398,
            "language": "shell",
            "tool": "shellcheck",
            "hash_v1": "031ab23297a2f30ddec4a2e9eaf15a4bf8a643c3",
            "key_event_idx": 0,
            "events": [
                {
                    "file_name": "/usr/share/podman/test/system/500-networking.bats",
                    "line": 860,
                    "column": 21,
                    "event": "error[SC1087]",
                    "message": "Use braces when expanding arrays, e.g. ${array[idx]} (or ${var}[.. to quiet).",
                    "verbosity_level": 0
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  858|       is \"$output\" \".*127.0.0.1[[:blank:]]localhost.*\" \"ipv4 localhost entry added\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  859|       is \"$output\" \".*::1[[:blank:]]localhost.*\" \"ipv6 localhost entry added\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  860|->     is \"$output\" \".*$containersinternal_ip[[:blank:]]host\\.containers\\.internal.*\" \"host.containers.internal ip from config in /etc/host\"",
                    "verbosity_level": 1
                },
                {
                    "file_name": "",
                    "line": 0,
                    "event": "#",
                    "message": "  861|       is \"${#lines[@]}\" \"7\" \"expect 7 host entries in /etc/hosts\"",
                    "verbosity_level": 1
           